/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.merge.diff;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.DiffConflictPair;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.DiffElement;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.PackageDiffCommonTools;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.PackageDiffConstant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class PackageDiffExecuteTool {
    public List<String> listEffectDiffElementId(List<DiffElement> diffElements, List<DiffConflictPair> diffConflictPairs) {
        HashMap<String, DiffElement> diffElementMap = new HashMap<String, DiffElement>();
        if (diffElements == null || diffElements.isEmpty()) {
            return new ArrayList<String>();
        }
        for (DiffElement diffElement : diffElements) {
            diffElementMap.put(diffElement.getDiffId(), diffElement);
        }
        if (diffConflictPairs == null || diffConflictPairs.isEmpty()) {
            return diffElementMap.keySet().stream().toList();
        }
        for (DiffConflictPair diffConflictPair : diffConflictPairs) {
            DiffElement diffElement;
            if (diffConflictPair.getChoseSrc().booleanValue()) {
                diffElement = diffConflictPair.getTargetDiffElement();
                diffElementMap.remove(diffConflictPair.getTargetDiffElement().getDiffId());
                if (diffElement.getChildDiffId() == null || diffElement.getChildDiffId().isEmpty()) continue;
                diffElement.getChildDiffId().forEach(childDiffId -> diffElementMap.remove(childDiffId));
                continue;
            }
            diffElement = diffConflictPair.getSrcDiffElement();
            diffElementMap.remove(diffConflictPair.getSrcDiffElement().getDiffId());
            if (diffElement.getChildDiffId() == null || diffElement.getChildDiffId().isEmpty()) continue;
            diffElement.getChildDiffId().forEach(childDiffId -> diffElementMap.remove(childDiffId));
        }
        return diffElementMap.keySet().stream().toList();
    }

    public void executeDiff(List<DiffElement> diffElements, List<String> effectDiffElementIds, WorkflowProjectPackage basePackage) {
        if (diffElements == null || diffElements.isEmpty()) {
            return;
        }
        if (effectDiffElementIds == null || effectDiffElementIds.isEmpty()) {
            return;
        }
        HashMap<String, Workflow> baseWorkflowMap = new HashMap<String, Workflow>();
        HashMap<String, WorkflowNode> baseWorkflowNodeMap = new HashMap<String, WorkflowNode>();
        HashMap<String, RelationPackage> baseRelationMap = new HashMap<String, RelationPackage>();
        PackageDiffCommonTools.buildMap(basePackage, baseWorkflowMap, baseWorkflowNodeMap, baseRelationMap);
        for (DiffElement diffElement : diffElements) {
            if (!effectDiffElementIds.contains(diffElement.getDiffId())) continue;
            switch (diffElement.getDiffType()) {
                case CONVERT_WORKFLOW_PROPERTY_UPDATE: 
                case TARGET_WORKFLOW_PROPERTY_UPDATE: {
                    Workflow workflow = (Workflow)baseWorkflowMap.get(diffElement.getWorkflow().getWorkflowId());
                    this.changeWorkflowProperty(workflow, diffElement);
                    break;
                }
                case CONVERT_NODE_PROPERTY_UPDATE: 
                case TARGET_NODE_PROPERTY_UPDATE: {
                    WorkflowNode workflowNode = (WorkflowNode)baseWorkflowNodeMap.get(diffElement.getWorkflowNode().getNodeId());
                    this.changeWorkflowNodeProperty(workflowNode, diffElement);
                    break;
                }
            }
        }
    }

    public void changeWorkflowProperty(Workflow workflow, DiffElement diffElement) {
        switch (PackageDiffConstant.WorkflowPropertyType.getWorkflowPropertyType(diffElement.getPropertyPath())) {
            case Owner: {
                workflow.setOwner(diffElement.getPropertyValue());
                break;
            }
            case Description: {
                workflow.setDescription(diffElement.getPropertyValue());
                break;
            }
            case ParamMap: {
                JSONObject paramJsonObj = JSONObject.parse((String)diffElement.getPropertyValue(), (JSONReader.Feature[])new JSONReader.Feature[0]);
                workflow.setParamMap(new HashMap());
                paramJsonObj.forEach((k, v) -> workflow.getParamMap().put(k, v));
                break;
            }
            case Cron: {
                if (workflow.getTriggers() == null) {
                    workflow.setTriggers(new ArrayList());
                }
                if (workflow.getTriggers().isEmpty()) {
                    workflow.getTriggers().add(new WorkflowTrigger());
                }
                ((WorkflowTrigger)workflow.getTriggers().get(0)).setCron(diffElement.getPropertyValue());
                break;
            }
            case InstanceMode: {
                if (workflow.getCustomProperties() == null) {
                    workflow.setCustomProperties(new HashMap());
                }
                workflow.getCustomProperties().put("instance.mode", diffElement.getPropertyValue());
            }
        }
    }

    public void changeWorkflowNodeProperty(WorkflowNode workflowNode, DiffElement diffElement) {
        switch (PackageDiffConstant.WorkflowNodePropertyType.getWorkflowNodePropertyType(diffElement.getPropertyPath())) {
            case Script: {
                workflowNode.setScript(diffElement.getPropertyValue());
                break;
            }
            case Owner: {
                workflowNode.setOwner(diffElement.getPropertyValue());
                break;
            }
            case Description: {
                workflowNode.setDescription(diffElement.getPropertyValue());
                break;
            }
            case ParamMap: {
                JSONObject paramJsonObj = JSONObject.parse((String)diffElement.getPropertyValue(), (JSONReader.Feature[])new JSONReader.Feature[0]);
                workflowNode.setParamMap(new HashMap());
                paramJsonObj.forEach((k, v) -> workflowNode.getParamMap().put(k, v));
                break;
            }
            case Cron: {
                if (workflowNode.getTrigger() == null) {
                    workflowNode.setTrigger(new WorkflowTrigger());
                }
                workflowNode.getTrigger().setCron(diffElement.getPropertyValue());
                break;
            }
            case InstanceMode: {
                workflowNode.setInstanceMode(WorkflowNode.InstanceMode.valueOf((String)diffElement.getPropertyValue()));
                break;
            }
            case State: {
                workflowNode.setState(WorkflowNode.Recurrence.valueOf((String)diffElement.getPropertyValue()));
                break;
            }
            case RerunMode: {
                workflowNode.setRerunMode(WorkflowNode.RerunMode.valueOf((String)diffElement.getPropertyValue()));
                break;
            }
            case ResourceGroupIdentifier: {
                if (workflowNode.getRuntimeResource() == null) {
                    workflowNode.setRuntimeResource(new HashMap());
                }
                workflowNode.getRuntimeResource().put("resource.group.identifier", diffElement.getPropertyValue());
                break;
            }
            case WorkflowCu: {
                if (workflowNode.getRuntimeResource() == null) {
                    workflowNode.setRuntimeResource(new HashMap());
                }
                workflowNode.getRuntimeResource().put("workflow.schedule.cu", diffElement.getPropertyValue());
                break;
            }
            case Image: {
                if (workflowNode.getRuntimeResource() == null) {
                    workflowNode.setRuntimeResource(new HashMap());
                }
                workflowNode.getRuntimeResource().put("resource.group.image.id", diffElement.getPropertyValue());
                break;
            }
            case DiResourceGroupIdentifier: {
                if (workflowNode.getRuntimeResource() == null) {
                    workflowNode.setRuntimeResource(new HashMap());
                }
                workflowNode.getRuntimeResource().put("di.resource.group.identifier", diffElement.getPropertyValue());
                break;
            }
            case DiWorkflowCu: {
                if (workflowNode.getRuntimeResource() == null) {
                    workflowNode.setRuntimeResource(new HashMap());
                }
                workflowNode.getRuntimeResource().put("workflow.di.cu", diffElement.getPropertyValue());
            }
        }
    }

    public WorkflowProjectPackage joinAllPackage(WorkflowProjectPackage srcPackage, WorkflowProjectPackage srcNovelPackage, WorkflowProjectPackage dstPackage, WorkflowProjectPackage dstNovelPackage) {
        WorkflowProjectPackage resultPackage = this.joinPackage(this.joinPackage(dstNovelPackage, dstPackage), this.joinPackage(srcNovelPackage, srcPackage));
        return resultPackage;
    }

    public WorkflowProjectPackage joinPackage(WorkflowProjectPackage highPackage, WorkflowProjectPackage lowPackage) {
        if (highPackage == null && lowPackage == null) {
            return null;
        }
        if (highPackage == null) {
            return (WorkflowProjectPackage)BwmJsonUtil.deepCopy((Object)lowPackage, WorkflowProjectPackage.class);
        }
        if (lowPackage == null) {
            return (WorkflowProjectPackage)BwmJsonUtil.deepCopy((Object)highPackage, WorkflowProjectPackage.class);
        }
        WorkflowProjectPackage resultPackage = (WorkflowProjectPackage)BwmJsonUtil.deepCopy((Object)highPackage, WorkflowProjectPackage.class);
        HashMap<String, Workflow> highWorkflowMap = new HashMap<String, Workflow>();
        HashMap<String, WorkflowNode> highWorkflowNodeMap = new HashMap<String, WorkflowNode>();
        HashMap<String, RelationPackage> highRelationMap = new HashMap<String, RelationPackage>();
        PackageDiffCommonTools.buildMap(highPackage, highWorkflowMap, highWorkflowNodeMap, highRelationMap);
        HashMap<String, Workflow> lowWorkflowMap = new HashMap<String, Workflow>();
        HashMap<String, WorkflowNode> lowWorkflowNodeMap = new HashMap<String, WorkflowNode>();
        HashMap<String, RelationPackage> lowRelationMap = new HashMap<String, RelationPackage>();
        PackageDiffCommonTools.buildMap(lowPackage, lowWorkflowMap, lowWorkflowNodeMap, lowRelationMap);
        resultPackage.setWorkflowList(new ArrayList());
        HashSet workflowIds = new HashSet();
        workflowIds.addAll(highWorkflowMap.keySet());
        workflowIds.addAll(lowWorkflowMap.keySet());
        for (String workflowId : workflowIds) {
            Workflow workflow;
            if (highWorkflowMap.containsKey(workflowId) && lowWorkflowMap.containsKey(workflowId)) {
                workflow = (Workflow)BwmJsonUtil.deepCopy((Object)((Workflow)highWorkflowMap.get(workflowId)), Workflow.class);
                workflow.setWorkflowNodes(new ArrayList());
                HashSet workflowNodeIds = new HashSet();
                ((Workflow)highWorkflowMap.get(workflowId)).getWorkflowNodes().stream().map(WorkflowNode::getNodeId).forEach(workflowNodeIds::add);
                ((Workflow)lowWorkflowMap.get(workflowId)).getWorkflowNodes().stream().map(WorkflowNode::getNodeId).forEach(workflowNodeIds::add);
                for (String workflowNodeId : workflowNodeIds) {
                    WorkflowNode workflowNode;
                    if (highWorkflowNodeMap.containsKey(workflowNodeId)) {
                        workflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)((WorkflowNode)highWorkflowNodeMap.get(workflowNodeId)), WorkflowNode.class);
                        workflow.getWorkflowNodes().add(workflowNode);
                        continue;
                    }
                    workflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)((WorkflowNode)lowWorkflowNodeMap.get(workflowNodeId)), WorkflowNode.class);
                    workflow.getWorkflowNodes().add(workflowNode);
                }
                workflow.setNodeRelations(new ArrayList());
                HashSet relationIds = new HashSet();
                ((Workflow)highWorkflowMap.get(workflowId)).getNodeRelations().stream().map(relationPackage -> relationPackage.getFrom() + " -> " + relationPackage.getTo()).forEach(relationIds::add);
                ((Workflow)lowWorkflowMap.get(workflowId)).getNodeRelations().stream().map(relationPackage -> relationPackage.getFrom() + " -> " + relationPackage.getTo()).forEach(relationIds::add);
                for (String relationId : relationIds) {
                    RelationPackage relationPackage2;
                    if (highRelationMap.containsKey(relationId)) {
                        relationPackage2 = (RelationPackage)BwmJsonUtil.deepCopy((Object)((RelationPackage)highRelationMap.get(relationId)), RelationPackage.class);
                        workflow.getNodeRelations().add(relationPackage2);
                        continue;
                    }
                    relationPackage2 = (RelationPackage)BwmJsonUtil.deepCopy((Object)((RelationPackage)lowRelationMap.get(relationId)), RelationPackage.class);
                    workflow.getNodeRelations().add(relationPackage2);
                }
                resultPackage.getWorkflowList().add(workflow);
                continue;
            }
            if (highWorkflowMap.containsKey(workflowId)) {
                workflow = (Workflow)BwmJsonUtil.deepCopy((Object)((Workflow)highWorkflowMap.get(workflowId)), Workflow.class);
                resultPackage.getWorkflowList().add(workflow);
                continue;
            }
            workflow = (Workflow)BwmJsonUtil.deepCopy((Object)((Workflow)lowWorkflowMap.get(workflowId)), Workflow.class);
            resultPackage.getWorkflowList().add(workflow);
        }
        return resultPackage;
    }
}

