/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.merge.diff;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.DiffConflictPair;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.DiffElement;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.PackageDiffCommonTools;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.PackageDiffConstant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PackageDiffConflictTool {
    public List<String> getInvalidDiffIds(List<DiffElement> diffElements, WorkflowProjectPackage basePackage) {
        ArrayList<String> invalidDiffIds = new ArrayList<String>();
        HashMap<String, Workflow> baseWorkflowMap = new HashMap<String, Workflow>();
        HashMap<String, WorkflowNode> baseWorkflowNodeMap = new HashMap<String, WorkflowNode>();
        HashMap<String, RelationPackage> baseRelationMap = new HashMap<String, RelationPackage>();
        PackageDiffCommonTools.buildMap(basePackage, baseWorkflowMap, baseWorkflowNodeMap, baseRelationMap);
        block7: for (DiffElement diffElement : diffElements) {
            switch (diffElement.getDiffType()) {
                case CONVERT_WORKFLOW_DELETE: 
                case CONVERT_WORKFLOW_PROPERTY_UPDATE: {
                    if (baseWorkflowMap.containsKey(diffElement.getWorkflow().getWorkflowId())) break;
                    invalidDiffIds.add(diffElement.getDiffId());
                    break;
                }
                case CONVERT_NODE_DELETE: 
                case CONVERT_NODE_PROPERTY_UPDATE: {
                    if (baseWorkflowNodeMap.containsKey(diffElement.getWorkflowNode().getNodeId())) break;
                    invalidDiffIds.add(diffElement.getDiffId());
                    break;
                }
                case CONVERT_NODE_CREATE: {
                    if (baseWorkflowMap.containsKey(diffElement.getWorkflowNode().getWorkflowId())) break;
                    Boolean belongsToNewWorkflow = false;
                    for (DiffElement d : diffElements) {
                        if (!ObjectUtils.equals((Object)((Object)d.getDiffType()), (Object)((Object)PackageDiffConstant.DiffType.CONVERT_WORKFLOW_CREATE)) || !StringUtils.equals((CharSequence)d.getWorkflow().getWorkflowId(), (CharSequence)diffElement.getWorkflowNode().getWorkflowId())) continue;
                        belongsToNewWorkflow = true;
                        break;
                    }
                    if (belongsToNewWorkflow.booleanValue()) continue block7;
                    invalidDiffIds.add(diffElement.getDiffId());
                    break;
                }
                case CONVERT_RELATION_DELETE: {
                    if (baseRelationMap.containsKey(diffElement.getRelation().getFrom() + " -> " + diffElement.getRelation().getTo())) break;
                    invalidDiffIds.add(diffElement.getDiffId());
                    break;
                }
                case CONVERT_RELATION_CREATE: {
                    Boolean isNewNode;
                    if (!baseRelationMap.containsKey(diffElement.getRelation().getFrom())) {
                        isNewNode = false;
                        for (DiffElement d : diffElements) {
                            if (ObjectUtils.equals((Object)((Object)d.getDiffType()), (Object)((Object)PackageDiffConstant.DiffType.CONVERT_NODE_CREATE)) && StringUtils.equals((CharSequence)d.getWorkflowNode().getNodeId(), (CharSequence)diffElement.getRelation().getFrom())) {
                                isNewNode = true;
                                break;
                            }
                            if (!ObjectUtils.equals((Object)((Object)d.getDiffType()), (Object)((Object)PackageDiffConstant.DiffType.CONVERT_WORKFLOW_CREATE)) || !StringUtils.equals((CharSequence)d.getWorkflow().getWorkflowId(), (CharSequence)diffElement.getRelation().getFrom())) continue;
                            isNewNode = true;
                            break;
                        }
                        if (!isNewNode.booleanValue()) {
                            invalidDiffIds.add(diffElement.getDiffId());
                            break;
                        }
                    }
                    if (baseRelationMap.containsKey(diffElement.getRelation().getTo())) break;
                    isNewNode = false;
                    for (DiffElement d : diffElements) {
                        if (ObjectUtils.equals((Object)((Object)d.getDiffType()), (Object)((Object)PackageDiffConstant.DiffType.CONVERT_NODE_CREATE)) && StringUtils.equals((CharSequence)d.getWorkflowNode().getNodeId(), (CharSequence)diffElement.getRelation().getTo())) {
                            isNewNode = true;
                            break;
                        }
                        if (!ObjectUtils.equals((Object)((Object)d.getDiffType()), (Object)((Object)PackageDiffConstant.DiffType.CONVERT_WORKFLOW_CREATE)) || !StringUtils.equals((CharSequence)d.getWorkflow().getWorkflowId(), (CharSequence)diffElement.getRelation().getTo())) continue;
                        isNewNode = true;
                        break;
                    }
                    if (isNewNode.booleanValue()) break;
                    invalidDiffIds.add(diffElement.getDiffId());
                    break;
                }
            }
        }
        return invalidDiffIds;
    }

    public List<DiffConflictPair> getConflictDiffIdPairs(List<DiffElement> cvtDiffElements, List<DiffElement> targetDiffElements) {
        if (cvtDiffElements == null || targetDiffElements == null) {
            return null;
        }
        ArrayList<DiffConflictPair> confictDiffIdPairs = new ArrayList<DiffConflictPair>();
        for (DiffElement cvtDiffElement : cvtDiffElements) {
            for (DiffElement targetDiffElement : targetDiffElements) {
                if (ObjectUtils.equals((Object)((Object)cvtDiffElement.getDiffType()), (Object)((Object)PackageDiffConstant.DiffType.CONVERT_WORKFLOW_PROPERTY_UPDATE)) && ObjectUtils.equals((Object)((Object)targetDiffElement.getDiffType()), (Object)((Object)PackageDiffConstant.DiffType.TARGET_WORKFLOW_PROPERTY_UPDATE)) && StringUtils.equals((CharSequence)cvtDiffElement.getWorkflow().getWorkflowId(), (CharSequence)targetDiffElement.getWorkflow().getWorkflowId()) && StringUtils.equals((CharSequence)cvtDiffElement.getPropertyPath(), (CharSequence)targetDiffElement.getPropertyPath()) && !ObjectUtils.equals((Object)cvtDiffElement.getPropertyValue(), (Object)targetDiffElement.getPropertyValue())) {
                    confictDiffIdPairs.add(DiffConflictPair.builder().srcDiffElement(cvtDiffElement).targetDiffElement(targetDiffElement).diffConflictType(PackageDiffConstant.DiffConflictType.SAME_WORKFLOW_PROPERTY_UPDATE).build());
                    continue;
                }
                if (!ObjectUtils.equals((Object)((Object)cvtDiffElement.getDiffType()), (Object)((Object)PackageDiffConstant.DiffType.CONVERT_NODE_PROPERTY_UPDATE)) || !ObjectUtils.equals((Object)((Object)targetDiffElement.getDiffType()), (Object)((Object)PackageDiffConstant.DiffType.TARGET_NODE_PROPERTY_UPDATE)) || !StringUtils.equals((CharSequence)cvtDiffElement.getWorkflowNode().getNodeId(), (CharSequence)targetDiffElement.getWorkflowNode().getNodeId()) || !StringUtils.equals((CharSequence)cvtDiffElement.getPropertyPath(), (CharSequence)targetDiffElement.getPropertyPath()) || ObjectUtils.equals((Object)cvtDiffElement.getPropertyValue(), (Object)targetDiffElement.getPropertyValue())) continue;
                confictDiffIdPairs.add(DiffConflictPair.builder().srcDiffElement(cvtDiffElement).targetDiffElement(targetDiffElement).diffConflictType(PackageDiffConstant.DiffConflictType.SAME_NODE_PROPERTY_UPDATE).build());
            }
        }
        return confictDiffIdPairs;
    }
}

