/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di.util;

import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJob;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfig;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigInput;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStep;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.Base64Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataArtsUtil {
    private static final Logger log = LoggerFactory.getLogger(DataArtsUtil.class);

    public static String getSql(List<DataArtsCdmJobConfigInput> inputList) {
        for (DataArtsCdmJobConfigInput input : inputList) {
            if (!"fromJobConfig.sql".equals(input.getName())) continue;
            try {
                String sql = new String(Base64Utils.decodeUtf8(input.getValue()));
                sql = sql.replaceAll("\n", " ").replaceAll("\t", " ").replaceAll("\\s+", " ").replaceAll(" ,", ",");
                return sql;
            }
            catch (Exception e) {
                log.error("deocde error", (Throwable)e);
            }
        }
        return null;
    }

    public static List<Integer> extractForStr(String str) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        String pattern = "-?[0-9]+";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(str);
        while (m.find()) {
            list.add(Integer.valueOf(m.group()));
        }
        return list;
    }

    public static String getMode(DiScriptStep sourceStep, DataArtsCdmJob dataArtsCdmJob) {
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJob.getFromConfigValues().getConfigs().get(0)).getInputs();
        for (DataArtsCdmJobConfigInput input : inputList) {
            if (!"fromJobConfig.useSql".equals(input.getName()) || !Boolean.valueOf(input.getValue()).booleanValue()) continue;
            return "code";
        }
        return "wizard";
    }
}

