/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.spec.domain.ConnectionMapping;
import com.aliyun.migration.spec.domain.DataArtsJobParamDTO;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfig;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigInput;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigValues;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.DISetpTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.annotation.DIRef;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.config.DataArtsDiConfig;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStep;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStepParameterODPS;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.RebuildPartitionDTO;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.Base64Utils;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.DataArtsUtil;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.ParamTemplateUtils;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.PartitionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@DIRef(value="ODPS_STEP_TYPE")
public class OdpsStepTypeHandler
implements DISetpTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(OdpsStepTypeHandler.class);

    @Override
    public DiScriptStep convertToDwSourceStep(DataArtsDiConfig config, List<DataArtsJobParamDTO> jobParams, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) throws RuntimeException {
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Reader");
        diScriptStep.setStepType("odps");
        diScriptStep.setCategory("reader");
        DiScriptStepParameterODPS setepParameter = new DiScriptStepParameterODPS();
        setepParameter.setTunnelQuota("default");
        String dbName = null;
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("fromJobConfig.database".equals(input.getName())) {
                dbName = input.getValue();
                continue;
            }
            if ("fromJobConfig.table".equals(input.getName())) {
                setepParameter.setTable(input.getValue());
                continue;
            }
            if ("toJobConfig.tableName".equals(input.getName())) {
                setepParameter.setTable(input.getValue());
                continue;
            }
            if ("fromJobConfig.columnList".equals(input.getName())) {
                setepParameter.setColumn(Arrays.asList(input.getValue().toLowerCase(Locale.ROOT).split("&")));
                continue;
            }
            if ("fromJobConfig.partitionValues".equals(input.getName())) {
                if (!StringUtils.isNotEmpty((CharSequence)input.getValue())) continue;
                HashMap<String, String> paramMap = new HashMap<String, String>();
                if (!CollectionUtils.isEmpty(jobParams)) {
                    for (DataArtsJobParamDTO jobParam : jobParams) {
                        paramMap.put(jobParam.getName(), jobParam.getValue());
                    }
                }
                JSONObject partitionValues = JSONObject.parseObject((String)input.getValue());
                ArrayList partitions = new ArrayList(partitionValues.size());
                partitionValues.entrySet().stream().forEach(partitionItem -> {
                    String partitionKey = (String)partitionItem.getKey();
                    Object partitionValue = (String)partitionItem.getValue();
                    paramMap.put("value", partitionKey);
                    paramMap.put(partitionKey, partitionKey);
                    StringSubstitutor stringSubstitutor = new StringSubstitutor(paramMap);
                    partitionValue = stringSubstitutor.replace((String)partitionValue);
                    log.info("OdpsStepTypeHandler partitionValue:{}", partitionValue);
                    if (((String)partitionValue).contains("&&") || ((String)partitionValue).contains(">") || ((String)partitionValue).contains("<")) {
                        RebuildPartitionDTO rebuildPartitionDTO = PartitionUtils.rebuildPartitionValueAndBackParam((String)partitionValue);
                        if (rebuildPartitionDTO != null) {
                            partitionValue = "/*query*/ " + rebuildPartitionDTO.getTargetPartition();
                            log.info("OdpsStepTypeHandler change partitionValue:{}", partitionValue);
                            partitions.add(partitionValue);
                        }
                    } else {
                        String dwParam = ParamTemplateUtils.converToDwDayParam((String)partitionValue);
                        if (!StringUtils.isEmpty((CharSequence)dwParam)) {
                            partitions.add(partitionKey + "=${" + partitionKey + "}");
                        } else {
                            partitions.add(partitionKey + "=" + partitionItem.getValue());
                        }
                    }
                });
                setepParameter.setPartition(partitions);
                continue;
            }
            if (!"fromJobConfig.sql".equals(input.getName())) continue;
            log.warn("DataWorks DI \u8bfb MaxCompute \u4e0d\u652f\u6301QuerySQL\uff0c\u9700\u4eba\u5de5\u5904\u7406:{}", (Object)Base64Utils.decodeUtf8(input.getValue()));
        }
        diScriptStep.setParameter(setepParameter);
        ConnectionMapping dwToDataSource = config.getConnectionMapping(dataArtsLinkName, dbName);
        setepParameter.setDatasource(dwToDataSource.getDwConnectionName());
        return diScriptStep;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DataArtsDiConfig config, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) throws RuntimeException {
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Writer");
        diScriptStep.setStepType("odps");
        diScriptStep.setCategory("writer");
        DiScriptStepParameterODPS setepParameter = new DiScriptStepParameterODPS();
        setepParameter.setTunnelQuota("default");
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        String dataArtsDataBase = null;
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("toJobConfig.table".equals(input.getName())) {
                setepParameter.setTable(input.getValue());
                continue;
            }
            if ("toJobConfig.tableName".equals(input.getName())) {
                setepParameter.setTable(input.getValue());
                continue;
            }
            if ("toJobConfig.columnList".equals(input.getName())) {
                setepParameter.setColumn(Arrays.asList(input.getValue().toLowerCase(Locale.ROOT).split("&")));
                continue;
            }
            if ("toJobConfig.database".equals(input.getName())) {
                dataArtsDataBase = input.getValue();
                continue;
            }
            if ("toJobConfig.shouldClearTable".equals(input.getName())) {
                setepParameter.setTruncate(Boolean.valueOf(input.getValue()));
                continue;
            }
            if (!"toJobConfig.tablePreparation".equals(input.getName()) || setepParameter.getTruncate() != null || !input.getValue().equalsIgnoreCase("CREATE_WHEN_NOT_EXIST") && !input.getValue().equalsIgnoreCase("DROP_AND_CREATE") && !input.getValue().equalsIgnoreCase("DO_NOTHING")) continue;
            setepParameter.setTruncate(true);
        }
        if (setepParameter.getTruncate() == null) {
            setepParameter.setTruncate(false);
        }
        try {
            String partitions;
            JSONObject extendConfigs;
            if (!StringUtils.isEmpty((CharSequence)dataArtsCdmJobConfigValues.getExtendedConfigs().getValue()) && (extendConfigs = JSONObject.parseObject((String)Base64Utils.decodeUtf8(dataArtsCdmJobConfigValues.getExtendedConfigs().getValue()))).containsKey("partitions") && (partitions = extendConfigs.getString("partitions")).contains("=")) {
                String key = partitions.split("=")[0];
                String value = partitions.split("=")[1];
                if (value.startsWith("'") && value.endsWith("'")) {
                    value = value.substring(1, value.length() - 2);
                }
                setepParameter.setPartition(key + "=" + value);
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790ExtendConfigs\u5931\u8d25,{}", (Throwable)e);
        }
        diScriptStep.setParameter(setepParameter);
        ConnectionMapping dwToDataSource = config.getConnectionMapping(dataArtsLinkName, dataArtsDataBase);
        setepParameter.setDatasource(dwToDataSource.getDwConnectionName());
        return diScriptStep;
    }

    private String dataArtsParamterToDw(String dataArtsParamter) {
        return dataArtsParamter.trim().replace("{", "[").replace("}", "]").replace("dateformat(", "").replace("DAY)", "").replace(",", "").replaceAll(" ", "").toLowerCase(Locale.ROOT);
    }

    private static Map<String, Integer> extractMinAndMax(String dataArtsParamter) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Integer min = 0;
        Integer max = 0;
        for (String item : dataArtsParamter.split("&&")) {
            List<Integer> maxList;
            List<Integer> minList;
            if (item.contains(">=")) {
                minList = DataArtsUtil.extractForStr(item.split(">=")[1]);
                if (minList.size() <= 0) continue;
                min = minList.get(minList.size() - 1);
                continue;
            }
            if (item.contains(">")) {
                minList = DataArtsUtil.extractForStr(item.split(">")[1]);
                if (minList.size() > 0) {
                    min = minList.get(minList.size() - 1) - 1;
                    continue;
                }
                min = min - 1;
                continue;
            }
            if (item.contains("<=")) {
                maxList = DataArtsUtil.extractForStr(item.split("<=")[1]);
                if (maxList.size() <= 0) continue;
                max = maxList.get(maxList.size() - 1);
                continue;
            }
            if (!item.contains("<")) continue;
            maxList = DataArtsUtil.extractForStr(item.split("<")[1]);
            max = maxList.size() > 0 ? Integer.valueOf(maxList.get(maxList.size() - 1) - 1) : Integer.valueOf(max - 1);
        }
        map.put("min", min);
        map.put("max", max);
        return map;
    }

    public static void main(String[] args) {
        String dataArtsParamter = "${dateformat(yyyy-MM-dd, -1, DAY)}";
        System.out.println(dataArtsParamter.replace("{", "[").replace("}", "]").replace("dateformat(", "").replace("DAY)", "").replace(",", "").replaceAll(" ", "").toLowerCase(Locale.ROOT));
        dataArtsParamter = "${data_date} >=${dateformat(yyyy-MM-dd, -8, DAY)} && ${data_date} < ${dateformat(yyyy-MM-dd)}";
        Map<String, Integer> map = OdpsStepTypeHandler.extractMinAndMax(dataArtsParamter);
        System.out.println(map);
        System.out.println("--------------");
        String str = dataArtsParamter;
        String pattern = "-?[0-9]+";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(str);
        while (m.find()) {
            System.out.println(m.group());
        }
        dataArtsParamter = "";
    }
}

