/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di;

import com.aliyun.migration.spec.domain.ConnectionMapping;
import com.aliyun.migration.spec.domain.DataArtsJobParamDTO;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfig;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigInput;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigValues;
import com.aliyun.migration.spec.domain.constant.DataArtsConstant;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.DISetpTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.annotation.DIRef;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.config.DataArtsDiConfig;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStep;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStepParameter;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.Base64Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DIRef(value="MONGODB_STEP_TYPE")
public class MongoDBStepTypeHandler
implements DISetpTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(MongoDBStepTypeHandler.class);

    @Override
    public DiScriptStep convertToDwSourceStep(DataArtsDiConfig config, List<DataArtsJobParamDTO> jobParams, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) {
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Reader");
        diScriptStep.setStepType("mongodb");
        diScriptStep.setCategory("reader");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        setepParameter.setDatasource(config.getConnectionMapping(dataArtsLinkName).getDwConnectionName());
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("fromJobConfig.collectionName".equals(input.getName())) {
                setepParameter.setCollectionName(input.getValue());
                continue;
            }
            if ("fromJobConfig.columnList".equals(input.getName())) {
                List<String> sourceColumnList = Arrays.asList(input.getValue().split("&"));
                ArrayList targetColumnList = new ArrayList();
                for (String column : sourceColumnList) {
                    HashMap<String, String> columnMap = new HashMap<String, String>();
                    columnMap.put("name", column);
                    targetColumnList.add(columnMap);
                }
                setepParameter.setColumn(targetColumnList);
                continue;
            }
            if ("fromJobConfig.whereClause".equals(input.getName())) {
                setepParameter.setWhere(Base64Utils.decodeUtf8(input.getValue()));
                continue;
            }
            if ("fromJobConfig.schemaName".equals(input.getName())) {
                setepParameter.setSelectedDatabase(input.getValue());
                continue;
            }
            if (!"fromJobConfig.filters".equals(input.getName())) continue;
            setepParameter.setQuery(input.getValue());
        }
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DataArtsDiConfig config, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) {
        DataArtsCdmJobConfig dataArtsCdmJobConfig = (DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0);
        ConnectionMapping dwFromDataSource = config.getConnectionMapping(dataArtsLinkName);
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Writer");
        diScriptStep.setStepType("mongodb");
        diScriptStep.setCategory("writer");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        setepParameter.setDatasource(dwFromDataSource.getDwConnectionName());
        List inputList = dataArtsCdmJobConfig.getInputs();
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("toJobConfig.collectionName".equals(input.getName())) {
                setepParameter.setCollectionName(input.getValue());
                continue;
            }
            if (!"toJobConfig.columnList".equals(input.getName())) continue;
            List<String> sourceColumnList = Arrays.asList(input.getValue().split("&"));
            ArrayList targetColumnList = new ArrayList();
            for (String column : sourceColumnList) {
                HashMap<String, String> columnMap = new HashMap<String, String>();
                columnMap.put("name", column);
                targetColumnList.add(columnMap);
            }
            setepParameter.setColumn(targetColumnList);
        }
        setepParameter.setBatchSize(DataArtsConstant.DW_DI_SYNC_BATCH_SIZE);
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }
}

