/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di;

import com.aliyun.migration.spec.domain.ConnectionMapping;
import com.aliyun.migration.spec.domain.DataArtsJobParamDTO;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfig;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigInput;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigValues;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.DISetpTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.annotation.DIRef;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.config.DataArtsDiConfig;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStep;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStepParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DIRef(value="HBASE_STEP_TYPE")
public class HbaseStepTypeHandler
implements DISetpTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(HbaseStepTypeHandler.class);

    @Override
    public DiScriptStep convertToDwSourceStep(DataArtsDiConfig config, List<DataArtsJobParamDTO> jobParams, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) {
        ConnectionMapping dwFromDataSource = config.getConnectionMapping(dataArtsLinkName);
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Reader");
        diScriptStep.setStepType("hbase");
        diScriptStep.setCategory("Reader");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        setepParameter.setDatasource(dwFromDataSource.getDwConnectionName());
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        setepParameter.setMode("normal");
        setepParameter.setHbaseVersion(config.getHBasePluginVersion());
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("fromJobConfig.table".equals(input.getName())) {
                setepParameter.setTable(input.getValue());
                continue;
            }
            if (!"fromJobConfig.columns".equals(input.getName())) continue;
            List<String> sourceColumnList = Arrays.asList(input.getValue().toLowerCase(Locale.ROOT).split("&"));
            ArrayList targetColumnList = new ArrayList();
            for (int i = 0; i < sourceColumnList.size(); ++i) {
                String column = sourceColumnList.get(i);
                HashMap<String, Object> columnMap = new HashMap<String, Object>();
                columnMap.put("index", i);
                columnMap.put("name", column);
                columnMap.put("type", "string");
                targetColumnList.add(columnMap);
            }
            setepParameter.setColumn(targetColumnList);
        }
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DataArtsDiConfig config, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) {
        ConnectionMapping dwFromDataSource = config.getConnectionMapping(dataArtsLinkName);
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Writer");
        diScriptStep.setStepType("hbase");
        diScriptStep.setCategory("writer");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        setepParameter.setDatasource(dwFromDataSource.getDwConnectionName());
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        setepParameter.setMode("normal");
        setepParameter.setHbaseVersion(config.getHBasePluginVersion());
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("toJobConfig.table".equals(input.getName())) {
                setepParameter.setTable(input.getValue());
                continue;
            }
            if ("toJobConfig.columns".equals(input.getName())) {
                List<String> sourceColumnList = Arrays.asList(input.getValue().toLowerCase(Locale.ROOT).split("&"));
                ArrayList targetColumnList = new ArrayList();
                for (int i = 0; i < sourceColumnList.size(); ++i) {
                    String column = sourceColumnList.get(i);
                    HashMap<String, Object> columnMap = new HashMap<String, Object>();
                    columnMap.put("index", i);
                    columnMap.put("name", column);
                    columnMap.put("type", "string");
                    targetColumnList.add(columnMap);
                }
                setepParameter.setColumn(targetColumnList);
                continue;
            }
            if ("toJobConfig.rowKeyColumn".equals(input.getName()) && StringUtils.isNotEmpty((CharSequence)input.getValue())) {
                ArrayList targetColumnList = new ArrayList();
                HashMap<String, Object> columnMap = new HashMap<String, Object>();
                columnMap.put("index", 0);
                columnMap.put("type", "string");
                targetColumnList.add(columnMap);
                setepParameter.setRowkeyColumn(targetColumnList);
                continue;
            }
            if (!"toJobConfig.writeToWAL".equals(input.getName())) continue;
            setepParameter.setWalFlag(Boolean.valueOf(input.getValue()));
        }
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }
}

