/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestApiConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(RestApiConvert.class);

    public RestApiConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public RestApiConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> res = new ArrayList<WorkflowNode>();
        ((List)Optional.ofNullable(workflowNodes).orElse(new ArrayList())).forEach(x -> {
            WorkflowNode workflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)x, WorkflowNode.class);
            if (Objects.isNull(workflowNode)) {
                log.error("convert node failed,{}", (Object)x.getNodeName());
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_CONVERT_FAILED);
            }
            if (workflowNode.getCustomProperties() != null && workflowNode.getCustomProperties().containsKey("method")) {
                switch (workflowNode.getCustomProperties().get("method").toString()) {
                    case "GET": {
                        if (!workflowNode.getCustomProperties().containsKey("url")) break;
                        Object getScript = "curl";
                        getScript = (String)getScript + " -X GET " + workflowNode.getCustomProperties().get("url").toString();
                        x.setScript((String)getScript);
                        break;
                    }
                    case "POST": {
                        if (!workflowNode.getCustomProperties().containsKey("url")) break;
                        Object postScript = "curl";
                        if (workflowNode.getCustomProperties().containsKey("body")) {
                            postScript = (String)postScript + " -d \"" + StringEscapeUtils.escapeJava((String)workflowNode.getCustomProperties().get("body").toString()) + "\"";
                        }
                        if (workflowNode.getCustomProperties().containsKey("headers")) {
                            postScript = (String)postScript + " -H \"" + StringEscapeUtils.escapeJava((String)workflowNode.getCustomProperties().get("head").toString()) + "\"";
                        }
                        postScript = (String)postScript + " -X POST " + workflowNode.getCustomProperties().get("url").toString();
                        x.setScript((String)postScript);
                        break;
                    }
                    case "PUT": 
                    case "DELETE": {
                        log.warn("put\u3001delete\u65b9\u6cd5\u6682\u4e0d\u652f\u6301\uff0c\u9700\u63d0\u4f9bcase\uff0c\u4e0d\u4fee\u6539\u811a\u672c");
                    }
                }
            }
            workflowNode.setNodeType(CodeProgramType.DIDE_SHELL.getName());
            res.add(workflowNode);
        });
        return res;
    }
}

