/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.WorkflowConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

public class DataArtsWorkflowConvert
extends WorkflowConvert {
    public DataArtsWorkflowConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public Workflow convert(Workflow workflow) {
        Workflow tgtworkflow = (Workflow)BwmJsonUtil.deepCopy((Object)workflow, Workflow.class);
        List nodeRelations = tgtworkflow.getNodeRelations();
        if (CollectionUtils.isEmpty((Collection)nodeRelations)) {
            return tgtworkflow;
        }
        boolean needAddHeadAndTail = false;
        for (RelationPackage relationPackage : nodeRelations) {
            if (relationPackage.getReType() != RelationPackage.ReType.WORKFLOW || !relationPackage.getTo().equals(tgtworkflow.getWorkflowName()) && !relationPackage.getFrom().equals(tgtworkflow.getWorkflowName())) continue;
            needAddHeadAndTail = true;
            break;
        }
        if (needAddHeadAndTail) {
            this.addHead(tgtworkflow);
            this.addTail(tgtworkflow);
        }
        List relationPackages = workflow.getNodeRelations();
        ((List)Optional.ofNullable(relationPackages).orElse(new ArrayList())).stream().filter(x -> null != x.getReType() && x.getReType() == RelationPackage.ReType.WORKFLOW).filter(x -> Objects.nonNull(x.getFrom()) && Objects.nonNull(x.getTo())).forEach(x -> {
            RelationPackage relationPackage;
            String toName;
            if (x.getFrom().equals(tgtworkflow.getWorkflowId())) {
                String fromName = Joiner.on((String)"_").join((Object)tgtworkflow.getWorkflowName(), (Object)"end", new Object[0]);
                String xTo = x.getTo();
                toName = Joiner.on((String)"_").join((Object)xTo, (Object)"start", new Object[0]);
                relationPackage = new RelationPackage(fromName, toName, RelationPackage.ReType.NODE);
                tgtworkflow.getNodeRelations().add(relationPackage);
            }
            if (x.getTo().equals(tgtworkflow.getWorkflowId())) {
                String xTo = x.getTo();
                String fromName = Joiner.on((String)"_").join((Object)xTo, (Object)"end", new Object[0]);
                toName = Joiner.on((String)"_").join((Object)tgtworkflow.getWorkflowName(), (Object)"start", new Object[0]);
                relationPackage = new RelationPackage(fromName, toName, RelationPackage.ReType.NODE);
                tgtworkflow.getNodeRelations().add(relationPackage);
            }
        });
        return tgtworkflow;
    }

    private void addHead(Workflow workflow) {
        WorkflowNode startNode = new WorkflowNode();
        startNode.setNodeType(CodeProgramType.VIRTUAL.getName());
        String nodeName = Joiner.on((String)"_").join((Object)workflow.getWorkflowName(), (Object)"start", new Object[0]);
        startNode.setNodeName(nodeName);
        startNode.setNodeId(nodeName);
        if (null == workflow.getWorkflowNodes()) {
            workflow.setWorkflowNodes(new ArrayList());
        }
        HashMap indegree = new HashMap();
        List workflowNodes = workflow.getWorkflowNodes();
        if (null == workflow.getNodeRelations()) {
            workflow.setNodeRelations(new ArrayList());
        }
        ((List)Optional.ofNullable(workflowNodes).orElse(new ArrayList())).forEach(x -> indegree.put(x.getNodeId(), 0));
        if (null == workflow.getNodeRelations()) {
            workflow.setNodeRelations(new ArrayList());
        }
        List relations = workflow.getNodeRelations();
        ((List)Optional.ofNullable(relations).orElse(new ArrayList())).stream().filter(x -> x.getReType() != RelationPackage.ReType.WORKFLOW).forEach(x -> {
            String to = x.getTo();
            indegree.put(to, indegree.getOrDefault(to, 0) + 1);
        });
        indegree.entrySet().stream().filter(x -> (Integer)x.getValue() == 0).map(Map.Entry::getKey).forEach(x -> {
            RelationPackage relationPackage = new RelationPackage(startNode.getNodeId(), x, RelationPackage.ReType.NODE);
            relations.add(relationPackage);
        });
        workflow.getWorkflowNodes().add(startNode);
    }

    private void addTail(Workflow workflow) {
        WorkflowNode endNode = new WorkflowNode();
        endNode.setNodeType(CodeProgramType.VIRTUAL.getName());
        String nodeName = Joiner.on((String)"_").join((Object)workflow.getWorkflowName(), (Object)"end", new Object[0]);
        endNode.setNodeName(nodeName);
        endNode.setNodeId(nodeName);
        if (null == workflow.getWorkflowNodes()) {
            workflow.setWorkflowNodes(new ArrayList());
        }
        HashMap outdegree = new HashMap();
        List workflowNodes = workflow.getWorkflowNodes();
        ((List)Optional.ofNullable(workflowNodes).orElse(new ArrayList())).forEach(x -> outdegree.put(x.getNodeId(), 0));
        if (null == workflow.getNodeRelations()) {
            workflow.setNodeRelations(new ArrayList());
        }
        List relations = workflow.getNodeRelations();
        ((List)Optional.ofNullable(relations).orElse(new ArrayList())).stream().filter(x -> x.getReType() != RelationPackage.ReType.WORKFLOW).forEach(x -> {
            String from = x.getFrom();
            outdegree.put(from, outdegree.getOrDefault(from, 0) + 1);
        });
        outdegree.entrySet().stream().filter(x -> (Integer)x.getValue() == 0).map(Map.Entry::getKey).forEach(x -> {
            RelationPackage relationPackage = new RelationPackage(x, endNode.getNodeId(), RelationPackage.ReType.NODE);
            relations.add(relationPackage);
        });
        workflow.getWorkflowNodes().add(endNode);
    }
}

