/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert;

import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvertFactory;
import com.aliyun.migration.workflow.migration.common.type.DataArtsNodeType;
import com.workflow.migration.transform.dw.converter.dataarts.convert.CdmConvert;
import com.workflow.migration.transform.dw.converter.dataarts.convert.DLFSubJobConvert;
import com.workflow.migration.transform.dw.converter.dataarts.convert.DLISparkConvert;
import com.workflow.migration.transform.dw.converter.dataarts.convert.DataArtsWorkflowConvert;
import com.workflow.migration.transform.dw.converter.dataarts.convert.DefaultNodeConvert;
import com.workflow.migration.transform.dw.converter.dataarts.convert.RestApiConvert;
import com.workflow.migration.transform.dw.converter.dataarts.convert.ShellConvert;
import com.workflow.migration.transform.dw.converter.dataarts.convert.SparkConvert;
import com.workflow.migration.transform.dw.converter.dataarts.convert.SqlConvert;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataArtsConvertFactory
extends AbstractConvertFactory {
    private static final Logger log = LoggerFactory.getLogger(DataArtsConvertFactory.class);

    public AbstractConvert<Workflow> getWorkflowConvert(TaskContext taskContext) {
        return new DataArtsWorkflowConvert(taskContext);
    }

    public AbstractConvert<List<WorkflowNode>> getNodeListConvert(String taskTypeStr, TaskContext taskContext, Workflow workflow) {
        DataArtsNodeType taskType = this.getTaskType(taskTypeStr);
        if (taskType == null) {
            log.warn("not supported thie tasktype {}, use default convert", (Object)taskTypeStr);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_TYPE_NOT_FOUND, (String)taskTypeStr);
        }
        return switch (taskType) {
            default -> throw new IncompatibleClassChangeError();
            case DataArtsNodeType.CDMJob -> new CdmConvert(taskContext, workflow);
            case DataArtsNodeType.HiveSQL, DataArtsNodeType.DWSSQL, DataArtsNodeType.DLISQL, DataArtsNodeType.RDSSQL, DataArtsNodeType.SparkSQL -> new SqlConvert(taskContext, workflow);
            case DataArtsNodeType.Shell -> new ShellConvert(taskContext, workflow);
            case DataArtsNodeType.MRSSpark -> new SparkConvert(taskContext, workflow);
            case DataArtsNodeType.DLFSubJob -> new DLFSubJobConvert(taskContext, workflow);
            case DataArtsNodeType.RESTAPI -> new RestApiConvert(taskContext, workflow);
            case DataArtsNodeType.DLISpark -> new DLISparkConvert(taskContext, workflow);
            case DataArtsNodeType.Note, DataArtsNodeType.Dummy, DataArtsNodeType.DataQualityMonitor -> new DefaultNodeConvert(taskContext, workflow);
        };
    }

    private DataArtsNodeType getTaskType(String taskTypeStr) {
        try {
            return DataArtsNodeType.valueOf((String)taskTypeStr);
        }
        catch (Exception e) {
            log.error("get taskType error");
            return null;
        }
    }
}

