/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIConfigTemplate;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.spec.domain.ConnectionMapping;
import com.aliyun.migration.spec.domain.DataArtsJobParamDTO;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJob;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfig;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigInput;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigValues;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.workflow.migration.transform.dw.converter.dataarts.convert.DataArtsParamConvert;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.DIHandlerFactory;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.DISetpTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.config.DataArtsDiConfig;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScript;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptExtend;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptOrder;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptOrderHops;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptSetting;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptSettingErrorLimit;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptSettingSpeed;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStep;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.DataArtsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CdmConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(CdmConvert.class);

    public CdmConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public CdmConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> res = new ArrayList<WorkflowNode>();
        ((List)Optional.ofNullable(workflowNodes).orElse(new ArrayList())).forEach(x -> {
            DataArtsCdmJob dataArtsCdmJob;
            WorkflowNode workflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)x, WorkflowNode.class);
            if (Objects.isNull(workflowNode)) {
                log.error("convert node failed,{}", (Object)x.getNodeName());
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_CONVERT_FAILED);
            }
            String script = workflowNode.getScript();
            if (StringUtils.isBlank((CharSequence)script)) {
                log.warn("cdmJob {} not found content, create a default di", (Object)workflowNode.getNodeName());
                workflowNode.setNodeType(CodeProgramType.DI.getName());
                workflowNode.setScript(DIConfigTemplate.DI_CODE_TEMPLATE);
                String diResourceGroup = this.selfConfMap.getOrDefault("workflow.di.resource.group", "");
                String resourceGroup = this.selfConfMap.getOrDefault("workflow.resource.group", "");
                float cu = this.selfConfMap.getOrDefault("workflow.di.cu", Float.valueOf(0.5f)).floatValue();
                if (CollectionUtils.isEmpty((Map)workflowNode.getRuntimeResource())) {
                    workflowNode.setRuntimeResource(new HashMap());
                }
                workflowNode.getRuntimeResource().put("di.resource.group.identifier", diResourceGroup);
                workflowNode.getRuntimeResource().put("resource.group.identifier", resourceGroup);
                workflowNode.getRuntimeResource().put("workflow.di.cu", String.valueOf(cu));
                res.add(workflowNode);
            }
            if (Objects.isNull(dataArtsCdmJob = (DataArtsCdmJob)BwmJsonUtil.parseObject((String)script, DataArtsCdmJob.class))) {
                log.error("parse DataArtsCdmJob error nodeName={} script={}", (Object)x.getNodeName(), (Object)script);
                return;
            }
            String jobType = dataArtsCdmJob.getJobType();
            if (jobType.equals("NORMAL_JOB")) {
                String diScript = this.getCode(workflowNode, dataArtsCdmJob);
                workflowNode.setScript(diScript);
                workflowNode.setNodeType(CodeProgramType.DI.getName());
                String diResourceGroup = this.selfConfMap.getOrDefault("workflow.di.resource.group", "");
                String resourceGroup = this.selfConfMap.getOrDefault("workflow.resource.group", "");
                if (CollectionUtils.isEmpty((Map)workflowNode.getCustomProperties())) {
                    workflowNode.setCustomProperties(new HashMap());
                }
                workflowNode.getCustomProperties().put("workflow.di.resource.group", diResourceGroup);
                workflowNode.getCustomProperties().put("workflow.resource.group", resourceGroup);
                DataArtsParamConvert.convertNodeParam(workflowNode);
                res.add(workflowNode);
            }
        });
        return res;
    }

    private String getDefaultDiCode() {
        return DIConfigTemplate.DI_CODE_TEMPLATE;
    }

    private String getCode(WorkflowNode workflowNode, DataArtsCdmJob dataArtsCdmJob) {
        String jobType = dataArtsCdmJob.getJobType();
        DataArtsDiConfig dataArtsDiConfig = new DataArtsDiConfig();
        dataArtsDiConfig.init(this.taskContext.getBwmConfiguration());
        if (jobType.equals("NORMAL_JOB")) {
            Object paramJson;
            ConnectionMapping dwToDataSource;
            ConnectionMapping dwFromDataSource;
            String srcDbName = null;
            try {
                block4: for (DataArtsCdmJobConfig config : dataArtsCdmJob.getFromConfigValues().getConfigs()) {
                    if (!config.getName().equals("fromJobConfig")) continue;
                    for (DataArtsCdmJobConfigInput input : config.getInputs()) {
                        if (!input.getName().equals("fromJobConfig.database")) continue;
                        srcDbName = input.getValue();
                        break;
                    }
                    if (!StringUtils.isEmpty(srcDbName)) continue;
                    for (DataArtsCdmJobConfigInput input : config.getInputs()) {
                        if (!input.getName().equals("fromJobConfig.schemaName")) continue;
                        srcDbName = input.getValue();
                        continue block4;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((dwFromDataSource = dataArtsDiConfig.getConnectionMapping(dataArtsCdmJob.getFromLinkName(), srcDbName)) == null) {
                log.error("dataArtsFromLinkName={} not find in mapping file,dataArts job={},", (Object)dataArtsCdmJob.getFromLinkName(), (Object)workflowNode.getNodeName());
                return this.getDefaultDiCode();
            }
            if (StringUtils.isEmpty((CharSequence)dwFromDataSource.getDwDataSourceType())) {
                log.error("dataArtsFromLinkName={} not find in mapping file,dataArts job={},", (Object)dataArtsCdmJob.getFromLinkName(), (Object)workflowNode.getNodeName());
                return this.getDefaultDiCode();
            }
            String tgtDbName = null;
            try {
                block7: for (DataArtsCdmJobConfig config : dataArtsCdmJob.getToConfigValues().getConfigs()) {
                    if (!config.getName().equals("toJobConfig")) continue;
                    for (DataArtsCdmJobConfigInput input : config.getInputs()) {
                        if (!input.getName().equals("toJobConfig.database")) continue;
                        tgtDbName = input.getValue();
                        break;
                    }
                    if (!StringUtils.isEmpty(tgtDbName)) continue;
                    for (DataArtsCdmJobConfigInput input : config.getInputs()) {
                        if (!input.getName().equals("toJobConfig.schemaName")) continue;
                        tgtDbName = input.getValue();
                        continue block7;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((dwToDataSource = dataArtsDiConfig.getConnectionMapping(dataArtsCdmJob.getToLinkName(), tgtDbName)) == null) {
                log.error("dataArtsToLinkName={} not find in mapping file,dataArts job={},", (Object)dataArtsCdmJob.getToLinkName(), (Object)workflowNode.getNodeName());
                return this.getDefaultDiCode();
            }
            if (StringUtils.isEmpty((CharSequence)dwToDataSource.getDwDataSourceType())) {
                log.error("dataArtsToLinkName={} not find in mapping file,dataArts job={},", (Object)dataArtsCdmJob.getToLinkName(), (Object)workflowNode.getNodeName());
                return this.getDefaultDiCode();
            }
            DISetpTypeHandler dISourceSetpTypeHandler = DIHandlerFactory.getDiHandle(dwFromDataSource.getDwDataSourceType() + "_STEP_TYPE");
            if (dISourceSetpTypeHandler == null) {
                log.error("dataArtsFromLinkName={} not supported....", (Object)dataArtsCdmJob.getFromLinkName());
                return this.getDefaultDiCode();
            }
            DISetpTypeHandler ddIDestSetpTypeHandler = DIHandlerFactory.getDiHandle(dwToDataSource.getDwDataSourceType() + "_STEP_TYPE");
            if (ddIDestSetpTypeHandler == null) {
                log.error("dataArtsT oLinkName={} not supported....", (Object)dataArtsCdmJob.getToLinkName());
                return this.getDefaultDiCode();
            }
            Map customProperties = workflowNode.getCustomProperties();
            List jobParams = null;
            if (Objects.nonNull(customProperties) && Objects.nonNull(paramJson = customProperties.get("JOB_PARAM"))) {
                jobParams = (List)BwmJsonUtil.parseObject((String)paramJson.toString(), (TypeReference)new TypeReference<List<DataArtsJobParamDTO>>(){});
            }
            DiScriptStep sourceStep = dISourceSetpTypeHandler.convertToDwSourceStep(dataArtsDiConfig, jobParams, dataArtsCdmJob.getFromConfigValues(), dataArtsCdmJob.getFromLinkName());
            DiScriptStep destStep = ddIDestSetpTypeHandler.convertToDwDestStep(dataArtsDiConfig, dataArtsCdmJob.getToConfigValues(), dataArtsCdmJob.getToLinkName());
            this.printCdmjobInfo(dataArtsCdmJob.getFromConfigValues(), dataArtsCdmJob.getToConfigValues(), dwFromDataSource.getDwDataSourceType(), dwToDataSource.getDwDataSourceType());
            DiScript diScript = this.converToDwDiScript(sourceStep, destStep, dataArtsCdmJob);
            String diScriptstr = JSONObject.toJSONString((Object)diScript);
            return diScriptstr;
        }
        throw new RuntimeException("jobType=" + jobType + " not supported");
    }

    private void printCdmjobInfo(DataArtsCdmJobConfigValues dataArtsCdmJobFromConfigValues, DataArtsCdmJobConfigValues dataArtsCdmJobToConfigValues, String dwFromDataSourceTypeName, String dwToDataSourceTypeName) {
        DataArtsCdmJobConfig dataArtsCdmJobFromConfig = (DataArtsCdmJobConfig)dataArtsCdmJobFromConfigValues.getConfigs().get(0);
        DataArtsCdmJobConfig dataArtsCdmJobToConfig = (DataArtsCdmJobConfig)dataArtsCdmJobToConfigValues.getConfigs().get(0);
        List fromInputList = dataArtsCdmJobFromConfig.getInputs();
        List toInputList = dataArtsCdmJobToConfig.getInputs();
        String fromTable = "";
        String fromDb = "";
        String toTable = "";
        String toDb = "";
        for (DataArtsCdmJobConfigInput input : fromInputList) {
            if ("fromJobConfig.tableName".equals(input.getName())) {
                fromTable = input.getValue();
            }
            if (!"fromJobConfig.schemaName".equals(input.getName())) continue;
            fromDb = input.getValue();
        }
        for (DataArtsCdmJobConfigInput input : toInputList) {
            if ("toJobConfig.tableName".equals(input.getName())) {
                toTable = input.getValue();
            }
            if (!"toJobConfig.schemaName".equals(input.getName())) continue;
            toDb = input.getValue();
        }
        log.info("cdmjob_info:sourceType={},targetType={},fromTable={},fromDb={},toTable={},toDb={}", new Object[]{dwFromDataSourceTypeName, dwToDataSourceTypeName, fromTable, fromDb, toTable, toDb});
    }

    private DiScript converToDwDiScript(DiScriptStep sourceStep, DiScriptStep destStep, DataArtsCdmJob dataArtsCdmJob) {
        DiScript diScript = new DiScript();
        diScript.setType("job");
        diScript.setTransform(false);
        diScript.setVersion("2.0");
        ArrayList<DiScriptStep> steps = new ArrayList<DiScriptStep>();
        steps.add(sourceStep);
        steps.add(destStep);
        DiScriptSetting setting = new DiScriptSetting();
        setting.setSpeed(this.initializeDiScriptSettingSpeed(dataArtsCdmJob.getDriverConfigValues()));
        Integer maxErrorRecords = this.maxErrorRecords(dataArtsCdmJob.getDriverConfigValues());
        if (maxErrorRecords != null) {
            DiScriptSettingErrorLimit diScriptSettingErrorLimit = new DiScriptSettingErrorLimit();
            diScriptSettingErrorLimit.setRecord(maxErrorRecords.toString());
            setting.setErrorLimit(diScriptSettingErrorLimit);
        }
        diScript.setSetting(setting);
        DiScriptExtend extend = new DiScriptExtend();
        extend.setMode(DataArtsUtil.getMode(sourceStep, dataArtsCdmJob));
        diScript.setExtend(extend);
        diScript.setOrder(this.initializeDiScriptOrder());
        diScript.setSteps(steps);
        return diScript;
    }

    private DiScriptOrder initializeDiScriptOrder() {
        DiScriptOrder diScriptOrder = new DiScriptOrder();
        ArrayList<DiScriptOrderHops> hops = new ArrayList<DiScriptOrderHops>();
        DiScriptOrderHops diScriptOrderHops = new DiScriptOrderHops();
        diScriptOrderHops.setFrom("Reader");
        diScriptOrderHops.setTo("Writer");
        hops.add(diScriptOrderHops);
        diScriptOrder.setHops(hops);
        return diScriptOrder;
    }

    private DiScriptSettingSpeed initializeDiScriptSettingSpeed(DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues) {
        DiScriptSettingSpeed diScriptSettingSpeed = new DiScriptSettingSpeed();
        diScriptSettingSpeed.setThrottle(false);
        List configs = dataArtsCdmJobConfigValues.getConfigs();
        List inputs = ((DataArtsCdmJobConfig)configs.get(0)).getInputs();
        for (DataArtsCdmJobConfigInput input : inputs) {
            if (!input.getName().equals("throttlingConfig.numExtractors")) continue;
            diScriptSettingSpeed.setConcurrent(Integer.valueOf(input.getValue()) > 8 ? 8 : Integer.valueOf(input.getValue()));
            break;
        }
        return diScriptSettingSpeed;
    }

    private Integer maxErrorRecords(DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues) {
        List inputs = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        for (DataArtsCdmJobConfigInput input : inputs) {
            if (!input.getName().equals("throttlingConfig.maxErrorRecords")) continue;
            return Integer.valueOf(input.getValue());
        }
        return null;
    }
}

