/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv1.handle;

import com.alibaba.cola.dto.Response;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerApi;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerApiService;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerRequest;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.dsv1.handle.Dolphinv1FileHandler;
import com.aliyun.migration.workflow.migration.dsv1.temp.DolphinSchedulerReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dolphinv1OpenApiHandler
extends Dolphinv1FileHandler {
    private static final Logger log = LoggerFactory.getLogger(Dolphinv1OpenApiHandler.class);
    private DolphinSchedulerReader dolphinSchedulerReader;
    private DolphinSchedulerApi dolphinSchedulerApiService;
    private Boolean needDownloadResource;

    public Dolphinv1OpenApiHandler(Datasource scheduleDataSource, TaskContext taskContext) {
        super(scheduleDataSource, taskContext);
    }

    @Override
    public void init() {
        Object sourceFilePath;
        String project;
        Map properties = this.scheduleDataSource.getProperties();
        String endpoint = (String)properties.get("endpoint");
        String token = (String)properties.get("token");
        this.project = project = (String)properties.get("project");
        String version = (String)properties.get("version");
        this.needDownloadResource = this.getIfNeedDownloadResource();
        if (!Dolphinv1OpenApiHandler.isValidVersion(version)) {
            version = "1.3.9";
        }
        if (StringUtils.isBlank((CharSequence)(sourceFilePath = (String)properties.get("source-file-path")))) {
            sourceFilePath = "temp/dolphinv1/" + this.scheduleDataSource.getName();
            properties.put("source-file-path", sourceFilePath);
        }
        List<String> projects = Collections.singletonList(project);
        this.dolphinSchedulerApiService = new DolphinSchedulerApiService(endpoint, token);
        this.dolphinSchedulerReader = new DolphinSchedulerReader(endpoint, token, version, projects, new ArrayList<Long>(), new File((String)sourceFilePath));
        this.dolphinSchedulerReader.setSkipResources(false);
    }

    @Override
    public Response preCheck(Datasource scheduleDataSource) {
        try {
            com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.Response listResponse = this.dolphinSchedulerApiService.queryAllProjectList(new DolphinSchedulerRequest());
            if (CollectionUtils.isEmpty((Collection)((Collection)listResponse.getData()))) {
                return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"not.find.the.projects");
            }
        }
        catch (Exception e) {
            log.error("detect.dolphinschedulev1.error", (Throwable)e);
            return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"detect.dolphinschedulev1.error");
        }
        return Response.buildSuccess();
    }

    @Override
    public WorkflowProjectPackage read() {
        File export = this.dolphinSchedulerReader.export();
        Map properties = this.scheduleDataSource.getProperties();
        properties.put("source-file-path", export.getPath());
        super.init();
        return super.read();
    }
}

