/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv1.handle;

import com.alibaba.cola.dto.Response;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service.DolphinSchedulerPackageLoader;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service.DolphinSchedulerV1PackageLoader;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNodeConnect;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.utils.ZipFileUtil;
import com.aliyun.migration.workflow.migration.dsv1.converter.Dolphinv12WorkflowConvert;
import com.aliyun.migration.workflow.migration.dsv1.handle.AbstractDolphinv1Handler;
import com.aliyun.migrationx.common.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dolphinv1FileHandler
extends AbstractDolphinv1Handler {
    private static final Logger log = LoggerFactory.getLogger(Dolphinv1FileHandler.class);
    private Dolphinv12WorkflowConvert converter = new Dolphinv12WorkflowConvert();
    protected DolphinSchedulerPackage<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> dolphinSchedulerPackage;

    public Dolphinv1FileHandler(Datasource scheduleDataSource, TaskContext taskContext) {
        super(scheduleDataSource, taskContext);
    }

    @Override
    public void init() {
        this.dolphinSchedulerPackage = this.load();
        this.fixRelation();
    }

    private void fixRelation() {
        for (ProcessMeta processMeta : (List)this.dolphinSchedulerPackage.getProcessDefinitions().get(((Project)this.dolphinSchedulerPackage.getProjects().get(0)).getName())) {
            if (processMeta.getProcessDefinitionJson().getTasks() == null) continue;
            for (TaskNode taskNode : processMeta.getProcessDefinitionJson().getTasks()) {
                if (taskNode.getPreTasks() == null || taskNode.getPreTasks().equals("[]")) continue;
                Dolphinv1FileHandler.stringToList(taskNode.getPreTasks()).forEach(preTaskName -> {
                    String from = this.getNodeIdFromNodeName(processMeta.getProcessDefinitionJson().getTasks(), (String)preTaskName);
                    String to = taskNode.getId();
                    TaskNodeConnect taskNodeConnect = new TaskNodeConnect();
                    taskNodeConnect.setEndPointSourceId(from);
                    taskNodeConnect.setEndPointTargetId(to);
                    processMeta.getProcessDefinitionConnects().add(taskNodeConnect);
                });
            }
        }
    }

    private String getNodeIdFromNodeName(List<TaskNode> nodes, String nodeName) {
        for (TaskNode node : nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node.getId();
        }
        return null;
    }

    private static List<String> stringToList(String str) {
        str = str.replaceAll("^\\[|\\]$", "");
        String[] items = str.split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String item : items) {
            item = item.trim().replaceAll("^\"|\"$", "");
            result.add(item);
        }
        return result;
    }

    protected DolphinSchedulerPackage load() {
        Map properties = this.scheduleDataSource.getProperties();
        String packagePath = properties.getOrDefault("source-file-path", "temp/dolphinv1/");
        File rootDir = new File(packagePath);
        try {
            File dataDir;
            Boolean isZip = false;
            if (rootDir.isFile()) {
                dataDir = ZipUtils.decompress((File)rootDir);
                isZip = true;
            } else {
                dataDir = rootDir;
            }
            log.info("load.file.success,dataDir:{}", (Object)dataDir.getAbsolutePath());
            DolphinSchedulerPackageLoader loader = this.getLoader(dataDir);
            loader.loadPackage();
            DolphinSchedulerPackage dolphinSchedulerPackage = loader.getDolphinSchedulerPackage();
            return dolphinSchedulerPackage;
        }
        catch (IOException e) {
            log.error("init.dolphin.export.error", (Throwable)e);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.DOLPHIN_LOADER_FILE_FAILED);
        }
    }

    protected DolphinSchedulerPackageLoader getLoader(File rootDir) {
        return new DolphinSchedulerV1PackageLoader(rootDir);
    }

    @Override
    public Response preCheck(Datasource scheduleDataSource) {
        Map properties = scheduleDataSource.getProperties();
        String packagePath = properties.getOrDefault("source-file-path", "temp/dolphinv1/");
        Response response = ZipFileUtil.checkFileType((String)packagePath);
        if (!response.isSuccess()) {
            return response;
        }
        try {
            File unzippedDir = new File(packagePath).isFile() ? ZipUtils.decompress((File)new File(packagePath)) : new File(packagePath);
            DolphinSchedulerPackageLoader loader = this.getLoader(unzippedDir);
            loader.loadPackage();
        }
        catch (IOException e) {
            log.error("load.file.error", (Throwable)e);
            return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"load.dolphin.file.error,detail.please.check.log");
        }
        return Response.buildSuccess();
    }

    @Override
    public WorkflowProjectPackage read() {
        WorkflowProjectPackage projectPackage = this.converter.convert(this.dolphinSchedulerPackage);
        return projectPackage;
    }
}

