/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.utils.filelock;

import com.alibaba.securitysdk.logging.utils.AssertUtil;
import com.alibaba.securitysdk.logging.utils.filelock.FailedLockingFileException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.logging.Logger;

public class FileLocker
implements Closeable {
    private static Logger logger = Logger.getLogger(FileLocker.class.getName());
    private static final int MAX_RETRY = 5;
    private static final long INTERVAL_MILL_SECONDS = 5000L;
    private final File lockFile;
    private final FileChannel channel;
    private FileLock mLock;

    public FileLocker(File lockFile) throws FailedLockingFileException {
        AssertUtil.notNull(lockFile);
        this.lockFile = lockFile;
        if (!lockFile.exists()) {
            throw new FailedLockingFileException("file not exist " + lockFile.getAbsolutePath());
        }
        try {
            this.channel = new RandomAccessFile(lockFile, "rw").getChannel();
        }
        catch (Exception ex) {
            throw new FailedLockingFileException(ex);
        }
    }

    public void tryLock(boolean shared) throws FailedLockingFileException {
        this.tryLock(0L, Long.MAX_VALUE, shared);
    }

    public void tryLock(long position, long size, boolean shared) throws FailedLockingFileException {
        int counter = 0;
        do {
            try {
                this.mLock = this.channel.tryLock(position, size, shared);
                if (this.mLock != null) {
                    return;
                }
                logger.info("The lock could not be acquired because another program holds the overlapping lock.");
            }
            catch (IOException | OverlappingFileLockException ex) {
                logger.warning(ex.getMessage());
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                throw new FailedLockingFileException(ie);
            }
        } while (counter++ < 5);
        throw new FailedLockingFileException("Failed to lock file: " + this.lockFile.getAbsolutePath());
    }

    public void unLock() throws FailedLockingFileException {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new FailedLockingFileException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.mLock != null) {
                this.mLock.release();
            }
        }
        finally {
            if (this.channel != null) {
                this.channel.close();
            }
        }
    }
}

