/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.utils;

import com.alibaba.securitysdk.logging.utils.AssertUtil;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Throwables {
    private Throwables() {
    }

    public static String currentFullStackTraceAsString() {
        return Throwables.fullStackTraceAsString(new Throwable());
    }

    public static String currentStackTraceAsString(int stackTopDepth, int stackBottomDepth) {
        return Throwables.stackTraceAsString(new Throwable(), stackTopDepth, stackBottomDepth);
    }

    public static String fullStackTraceAsString(Throwable throwable) {
        StackTraceElement[] stackTraces = AssertUtil.notNull(throwable).getStackTrace();
        return Throwables.stackTraceAsString(throwable, stackTraces.length, 0);
    }

    public static String stackTraceAsString(Throwable throwable, int stackTopDepth, int stackBottomDepth) {
        int i;
        AssertUtil.notNull(throwable);
        AssertUtil.checkArgument(stackTopDepth >= 0);
        AssertUtil.checkArgument(stackBottomDepth >= 0);
        if (stackTopDepth + stackBottomDepth == 0) {
            return "";
        }
        int stackLength = stackTopDepth + stackBottomDepth;
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackLength >= stackTrace.length) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (i = 0; i < stackTopDepth; ++i) {
            stringBuilder.append(stackTrace[i]).append("\n");
        }
        if (stackTopDepth > 0 && stackBottomDepth > 0) {
            stringBuilder.append("...");
        }
        for (i = stackTrace.length - stackBottomDepth; i < stackTrace.length; ++i) {
            stringBuilder.append(stackTrace[i]).append("\n");
        }
        return stringBuilder.toString();
    }
}

