/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.api.ext;

import com.aliyun.securitysdk.rass.api.Permission;
import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.condition.Action;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public abstract class ConfigurablePermission<T>
implements Permission<T> {
    private final String name;
    private final List<Action> actionList;
    private final PermissionMode permissionMode;
    private T resource;

    public ConfigurablePermission(String name, @NonNull T resource, Action ... actions) {
        this(name, PermissionMode.Operation, resource, actions);
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
    }

    public ConfigurablePermission(String name, PermissionMode permissionMode, @NonNull T resource, Action ... actions) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.name = name;
        this.permissionMode = permissionMode;
        this.actionList = Arrays.asList(actions);
        this.resource = resource;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Action> getActionList() {
        return this.actionList;
    }

    public PermissionMode getPermissionMode() {
        return this.permissionMode;
    }

    @Override
    public T getResource() {
        return this.resource;
    }
}

