/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.api.ext;

import com.aliyun.securitysdk.rass.api.Permission;
import com.aliyun.securitysdk.rass.api.PermissionChecker;
import com.aliyun.securitysdk.rass.api.annotation.Order;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CompositePermissionChecker<P extends Permission> {
    private List<PermissionChecker<P>> permissionCheckers;

    public CompositePermissionChecker(Collection<PermissionChecker<P>> permissionCheckers) {
        this.permissionCheckers = new ArrayList<PermissionChecker<P>>(permissionCheckers);
        Collections.sort(this.permissionCheckers, new Comparator<PermissionChecker<P>>(){

            @Override
            public int compare(PermissionChecker<P> o1, PermissionChecker<P> o2) {
                return this.getOrderValue(o1) - this.getOrderValue(o2);
            }

            private int getOrderValue(PermissionChecker<P> permissionChecker) {
                Order order = permissionChecker.getClass().getAnnotation(Order.class);
                if (order != null) {
                    return order.value();
                }
                return Integer.MAX_VALUE;
            }
        });
    }

    public List<PermissionChecker<P>> getOrderedSet() {
        return this.permissionCheckers;
    }
}

