/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.api.config;

import com.alibaba.securitysdk.com.typesafe.config.Config;
import com.alibaba.securitysdk.com.typesafe.config.ConfigBeanFactory;
import com.alibaba.securitysdk.com.typesafe.config.ConfigFactory;
import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.RassConstants;
import com.aliyun.securitysdk.rass.api.config.Configs;
import com.aliyun.securitysdk.rass.api.config.RassConfig;
import java.io.File;

public class ConfigLoader {
    private static final Logger logger = SecurityLogManager.getLogger(ConfigLoader.class);
    private static RassConfig rassConfig;
    private static final String DEFAULT_CONFIG_PATH = "rass";
    private static final String CONFIG_SUFFIX = "aliyun.rass";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RassConfig loadSecurityConfig() {
        if (rassConfig != null) return rassConfig;
        Class<ConfigLoader> clazz = ConfigLoader.class;
        synchronized (ConfigLoader.class) {
            if (rassConfig != null) return rassConfig;
            try {
                Config config = ConfigFactory.parseFile((File)new File(RassConstants.DYNAMIC_RASS_PROPERTIES_PATH)).getConfig(CONFIG_SUFFIX);
                rassConfig = (RassConfig)ConfigBeanFactory.create((Config)config, RassConfig.class);
                // ** MonitorExit[var0] (shouldn't be in output)
                return rassConfig;
            }
            catch (Exception ex) {
                logger.info("No override configuration.");
                try {
                    Config config = Configs.newBuilder(true).build().getConfig(CONFIG_SUFFIX);
                    rassConfig = (RassConfig)ConfigBeanFactory.create((Config)config, RassConfig.class);
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return rassConfig;
                }
                catch (Exception ex2) {
                    logger.warn("Failed to load config from application.properties, msg:{}", (Object)ex2.getMessage());
                    try {
                        Config config = ConfigFactory.load((String)DEFAULT_CONFIG_PATH).resolve().getConfig(CONFIG_SUFFIX);
                        rassConfig = (RassConfig)ConfigBeanFactory.create((Config)config, RassConfig.class);
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return rassConfig;
                    }
                    catch (Exception ex3) {
                        logger.warn("Failed to load config from {} file, msg:{}", (Object)DEFAULT_CONFIG_PATH, (Object)ex3.getMessage());
                        rassConfig = new RassConfig();
                    }
                }
            }
            return rassConfig;
        }
    }

    public static void clear() {
        rassConfig = null;
    }
}

