/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.api;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.RuntimeApplicationSecuritySandbox;
import com.aliyun.securitysdk.rass.api.annotation.Order;
import com.aliyun.securitysdk.rass.api.config.ConfigLoader;
import com.aliyun.securitysdk.rass.api.config.RassConfig;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class RassBootstrap {
    private static final Logger logger = SecurityLogManager.getLogger(RassBootstrap.class);
    private static final AtomicBoolean INIT = new AtomicBoolean(false);
    private static RuntimeApplicationSecuritySandbox runtimeApplicationSecuritySandbox;

    public static RuntimeApplicationSecuritySandbox startRuntimeApplicationSecuritySandbox() {
        if (runtimeApplicationSecuritySandbox != null) {
            return runtimeApplicationSecuritySandbox;
        }
        if (INIT.compareAndSet(false, true)) {
            RassConfig rassConfig = ConfigLoader.loadSecurityConfig();
            if (!rassConfig.isEnabled()) {
                logger.info("Rass is disabled!");
                return null;
            }
            runtimeApplicationSecuritySandbox = RassBootstrap.loadService();
            if (runtimeApplicationSecuritySandbox == null) {
                logger.info("No implementations for RuntimeApplicationSecuritySandbox.");
                return null;
            }
            runtimeApplicationSecuritySandbox.initialize();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    runtimeApplicationSecuritySandbox.destroy();
                }
            });
        }
        return runtimeApplicationSecuritySandbox;
    }

    public static RuntimeApplicationSecuritySandbox loadService() {
        RuntimeApplicationSecuritySandbox ret = null;
        int orderValue = Integer.MAX_VALUE;
        for (RuntimeApplicationSecuritySandbox impl : ServiceLoader.load(RuntimeApplicationSecuritySandbox.class, RuntimeApplicationSecuritySandbox.class.getClassLoader())) {
            int v = Integer.MAX_VALUE;
            Order order = impl.getClass().getAnnotation(Order.class);
            if (order != null) {
                v = order.value();
            }
            if (v >= orderValue) continue;
            orderValue = v;
            ret = impl;
        }
        return ret;
    }
}

