/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.api;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.CheckResult;
import com.aliyun.securitysdk.rass.api.Permission;
import com.aliyun.securitysdk.rass.api.PermissionChecker;
import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.RuntimeApplicationSecuritySandbox;
import com.aliyun.securitysdk.rass.api.condition.PermissionMatcher;
import com.aliyun.securitysdk.rass.api.condition.matcher.SamePermissionMatcher;
import com.aliyun.securitysdk.rass.api.exception.PermissionException;
import com.aliyun.securitysdk.rass.api.exception.ProvideFailedException;
import com.aliyun.securitysdk.rass.api.ext.CompositePermissionChecker;
import com.aliyun.securitysdk.rass.api.interceptor.CheckInterceptor;
import com.aliyun.securitysdk.rass.api.interceptor.CompositeCheckInterceptor;
import com.aliyun.securitysdk.rass.api.provider.Information;
import com.aliyun.securitysdk.rass.api.provider.InformationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class RaptSecurityContext {
    private static final Logger logger = SecurityLogManager.getLogger(RaptSecurityContext.class);
    private volatile UUID currentVersion;
    private RuntimeApplicationSecuritySandbox runtimeApplicationSecuritySandbox;
    private CompositeCheckInterceptor interceptors = new CompositeCheckInterceptor(new CheckInterceptor[0]);
    private Map<Class<? extends Permission>, CheckInterceptor> permission2InterceptorMap = new HashMap<Class<? extends Permission>, CheckInterceptor>();
    private Map<Class<? extends Permission>, List<PermissionChecker>> typedPermissionCheckerMatcherMap = new HashMap<Class<? extends Permission>, List<PermissionChecker>>();
    private Map<PermissionMatcher, PermissionChecker> permissionCheckerMatcherMap = new HashMap<PermissionMatcher, PermissionChecker>();
    private Map<Class<? extends Information>, InformationProvider> informationProviders = new HashMap<Class<? extends Information>, InformationProvider>();
    private Map<Class<? extends Permission>, CompositePermissionChecker<? extends Permission>> cachedCompositePermissionChecker = new HashMap<Class<? extends Permission>, CompositePermissionChecker<? extends Permission>>();
    private Map<Class<? extends Permission>, CompositeCheckInterceptor> cachedPermissionInterceptor = new HashMap<Class<? extends Permission>, CompositeCheckInterceptor>();

    public RaptSecurityContext(RuntimeApplicationSecuritySandbox runtimeApplicationSecuritySandbox) {
        this.runtimeApplicationSecuritySandbox = runtimeApplicationSecuritySandbox;
    }

    private RuntimeApplicationSecuritySandbox.Status getStatus() {
        return this.runtimeApplicationSecuritySandbox.getStatus();
    }

    private boolean canRegister() {
        return this.getStatus() == RuntimeApplicationSecuritySandbox.Status.Initializing || this.getStatus() == RuntimeApplicationSecuritySandbox.Status.Reloading;
    }

    public void registerInfoProvider(InformationProvider informationProvider) {
        if (!this.canRegister()) {
            return;
        }
        this.informationProviders.put(informationProvider.getTargetClass(), informationProvider);
    }

    public List<Information> provideAllInformation() {
        ArrayList<Information> results = new ArrayList<Information>();
        for (InformationProvider provider : this.informationProviders.values()) {
            try {
                results.add((Information)provider.provides());
            }
            catch (ProvideFailedException ex) {
                logger.warn("Failed to provide {}", (Object)provider.getName());
            }
        }
        return results;
    }

    public void registerPermissionChecker(PermissionChecker<?> permissionChecker, PermissionMatcher permissionMatcher) {
        if (!this.canRegister()) {
            return;
        }
        if (permissionMatcher instanceof SamePermissionMatcher) {
            this.registerTypedPermissionCheck(permissionChecker, ((SamePermissionMatcher)permissionMatcher).getType());
        }
        this.permissionCheckerMatcherMap.put(permissionMatcher, permissionChecker);
        this.cachedCompositePermissionChecker.clear();
    }

    public void registerTypedPermissionCheck(PermissionChecker<?> permissionChecker, Class<? extends Permission> permissionType) {
        if (!this.canRegister()) {
            return;
        }
        List<PermissionChecker> checkers = this.typedPermissionCheckerMatcherMap.get(permissionType);
        if (checkers == null) {
            checkers = new ArrayList<PermissionChecker>();
            this.typedPermissionCheckerMatcherMap.put(permissionType, checkers);
        }
        checkers.add(permissionChecker);
        this.cachedCompositePermissionChecker.clear();
    }

    public <T> void registerCheckInterceptor(Permission<T> permission, CheckInterceptor checkInterceptor) {
        if (!this.canRegister()) {
            return;
        }
        this.permission2InterceptorMap.put(permission.getClass(), checkInterceptor);
        this.cachedPermissionInterceptor.clear();
    }

    public void registerGlobalCheckInterceptor(CheckInterceptor interceptor) {
        if (!this.canRegister()) {
            return;
        }
        this.interceptors.addInterceptor(interceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<CheckResult> check(Permission<T> permission) throws PermissionException {
        if (permission == null) {
            return Collections.emptyList();
        }
        CompositeCheckInterceptor<Permission<Permission<T>>> interceptor = this.cachedPermissionInterceptor.get(permission.getClass());
        if (interceptor == null) {
            CheckInterceptor checkInterceptor = this.permission2InterceptorMap.get(permission.getClass());
            interceptor = this.interceptors.copyWith(checkInterceptor);
            this.cachedPermissionInterceptor.put(permission.getClass(), interceptor);
        }
        if (!interceptor.preCheck(permission)) {
            return Collections.emptyList();
        }
        CompositePermissionChecker<Permission<T>> compositePermissionChecker = this.selectPermissionChecker(permission);
        List<PermissionChecker<Permission<T>>> orderedSet = compositePermissionChecker.getOrderedSet();
        ArrayList<CheckResult> checkResults = new ArrayList<CheckResult>();
        for (PermissionChecker<Permission<T>> checker : orderedSet) {
            CheckResult checkResult = null;
            try {
                if (checker.getPermissionMode() == PermissionMode.Operation) {
                    checkResult = checker.handle(permission);
                    checkResults.add(checkResult);
                    continue;
                }
                if (checker.getPermissionMode() != PermissionMode.Observation) continue;
                checkResult = checker.observe(permission);
            }
            finally {
                interceptor.postCheck(permission, checkResult);
            }
        }
        return checkResults;
    }

    public boolean shouldCheckPermissionWithoutMatcher(Class<? extends Permission> permissionType) {
        return this.typedPermissionCheckerMatcherMap.containsKey(permissionType);
    }

    private <T extends Permission> CompositePermissionChecker<T> selectPermissionChecker(T permission) {
        CompositePermissionChecker<Permission<Object>> compositePermissionChecker = this.cachedCompositePermissionChecker.get(permission.getClass());
        if (compositePermissionChecker != null) {
            return compositePermissionChecker;
        }
        HashSet permissionCheckers = new HashSet();
        for (PermissionMatcher permissionMatcher : this.permissionCheckerMatcherMap.keySet()) {
            if (!permissionMatcher.matches(permission)) continue;
            permissionCheckers.add(this.permissionCheckerMatcherMap.get(permissionMatcher));
        }
        List<PermissionChecker> checkers = this.typedPermissionCheckerMatcherMap.get(permission.getClass());
        if (checkers == null) {
            checkers = new ArrayList<PermissionChecker>();
        }
        for (PermissionChecker _checker : checkers) {
            permissionCheckers.add(_checker);
        }
        compositePermissionChecker = new CompositePermissionChecker(permissionCheckers);
        this.cachedCompositePermissionChecker.put(permission.getClass(), compositePermissionChecker);
        return compositePermissionChecker;
    }

    public UUID getCurrentVersion() {
        return this.currentVersion;
    }

    public RuntimeApplicationSecuritySandbox getRuntimeApplicationSecuritySandbox() {
        return this.runtimeApplicationSecuritySandbox;
    }

    public CompositeCheckInterceptor getInterceptors() {
        return this.interceptors;
    }

    public Map<Class<? extends Permission>, CheckInterceptor> getPermission2InterceptorMap() {
        return this.permission2InterceptorMap;
    }

    public Map<Class<? extends Permission>, List<PermissionChecker>> getTypedPermissionCheckerMatcherMap() {
        return this.typedPermissionCheckerMatcherMap;
    }

    public Map<PermissionMatcher, PermissionChecker> getPermissionCheckerMatcherMap() {
        return this.permissionCheckerMatcherMap;
    }

    public Map<Class<? extends Information>, InformationProvider> getInformationProviders() {
        return this.informationProviders;
    }

    public Map<Class<? extends Permission>, CompositePermissionChecker<? extends Permission>> getCachedCompositePermissionChecker() {
        return this.cachedCompositePermissionChecker;
    }

    public Map<Class<? extends Permission>, CompositeCheckInterceptor> getCachedPermissionInterceptor() {
        return this.cachedPermissionInterceptor;
    }

    public void setCurrentVersion(UUID currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void setRuntimeApplicationSecuritySandbox(RuntimeApplicationSecuritySandbox runtimeApplicationSecuritySandbox) {
        this.runtimeApplicationSecuritySandbox = runtimeApplicationSecuritySandbox;
    }

    public void setInterceptors(CompositeCheckInterceptor interceptors) {
        this.interceptors = interceptors;
    }

    public void setPermission2InterceptorMap(Map<Class<? extends Permission>, CheckInterceptor> permission2InterceptorMap) {
        this.permission2InterceptorMap = permission2InterceptorMap;
    }

    public void setTypedPermissionCheckerMatcherMap(Map<Class<? extends Permission>, List<PermissionChecker>> typedPermissionCheckerMatcherMap) {
        this.typedPermissionCheckerMatcherMap = typedPermissionCheckerMatcherMap;
    }

    public void setPermissionCheckerMatcherMap(Map<PermissionMatcher, PermissionChecker> permissionCheckerMatcherMap) {
        this.permissionCheckerMatcherMap = permissionCheckerMatcherMap;
    }

    public void setInformationProviders(Map<Class<? extends Information>, InformationProvider> informationProviders) {
        this.informationProviders = informationProviders;
    }

    public void setCachedCompositePermissionChecker(Map<Class<? extends Permission>, CompositePermissionChecker<? extends Permission>> cachedCompositePermissionChecker) {
        this.cachedCompositePermissionChecker = cachedCompositePermissionChecker;
    }

    public void setCachedPermissionInterceptor(Map<Class<? extends Permission>, CompositeCheckInterceptor> cachedPermissionInterceptor) {
        this.cachedPermissionInterceptor = cachedPermissionInterceptor;
    }
}

