/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.uri;

import com.alibaba.security.util.StringUtils;
import com.alibaba.security.util.UrlUtil;
import com.alibaba.security.xss.uri.UriEscape;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomUriEscape {
    private static final String[] FORBIDDEN_PROTOCOLS = new String[]{"javascript", "ftp"};
    private static final String[] DEFAULT_PROTOCOLS = new String[]{"http", "https"};
    private static final Logger LOGGER = Logger.getLogger(CustomUriEscape.class.getName());
    public static Set<String> customProtocols = new CopyOnWriteArraySet<String>();

    public static boolean addCustomProtocol(String customProtocol) {
        if (StringUtils.isBlank(customProtocol)) {
            return false;
        }
        customProtocol = customProtocol.trim().toLowerCase();
        for (String forbiddenProtocol : FORBIDDEN_PROTOCOLS) {
            if (!forbiddenProtocol.equals(customProtocol)) continue;
            return false;
        }
        for (String defaultProtocol : DEFAULT_PROTOCOLS) {
            if (!defaultProtocol.equals(customProtocol)) continue;
            return true;
        }
        customProtocols.add(customProtocol);
        return true;
    }

    public static boolean removeCustomProtocol(String customProtocol) {
        if (StringUtils.isBlank(customProtocol)) {
            return false;
        }
        customProtocol = customProtocol.trim().toLowerCase();
        return customProtocols.remove(customProtocol);
    }

    public static List<String> listProtocols() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(DEFAULT_PROTOCOLS));
        result.addAll(customProtocols);
        return result;
    }

    public static String escapeUri(String text) {
        if (StringUtils.isBlank(text)) {
            return text;
        }
        try {
            URI uri = new URI(text);
            String scheme = uri.getScheme();
            if (scheme != null) {
                scheme = scheme.toLowerCase();
            }
            if (!CustomUriEscape.isAllowedProtocol(scheme)) {
                return null;
            }
            return new URIBuilder(uri).setScheme(scheme).build();
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, "Fail to parse uri [" + text + "]", e);
            return CustomUriEscape.escapeUriForURISyntaxException(text);
        }
    }

    private static String escapeUriForURISyntaxException(String text) {
        if (StringUtils.isBlank(text)) {
            return text;
        }
        String tempText = text;
        if (!text.contains("://") && text.contains(":")) {
            tempText = text.replaceFirst(":", "://");
        }
        try {
            if (!CustomUriEscape.isAllowedProtocol(UrlUtil.getScheme(tempText))) {
                return null;
            }
            return UriEscape.escapeUriFragmentId(text);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Fail to escape uri [" + text + "]", e);
            return null;
        }
    }

    private static boolean isAllowedProtocol(String scheme) {
        if (scheme == null) {
            return true;
        }
        for (String defaultProtocol : DEFAULT_PROTOCOLS) {
            if (!defaultProtocol.equals(scheme)) continue;
            return true;
        }
        if (customProtocols.contains(scheme)) {
            return true;
        }
        for (String forbiddenProtocol : FORBIDDEN_PROTOCOLS) {
            if (!forbiddenProtocol.equals(scheme)) continue;
            return false;
        }
        return false;
    }

    private static class URIBuilder {
        private String scheme;
        private String authority;
        private String path;
        private String query;
        private String fragment;

        URIBuilder(URI uri) {
            this.authority = uri.getRawAuthority();
            this.path = uri.getRawPath();
            this.query = uri.getRawQuery();
            this.fragment = uri.getRawFragment();
        }

        URIBuilder setScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public URIBuilder setPath(String path) {
            this.path = path;
            return this;
        }

        public URIBuilder setQuery(String query) {
            this.query = query;
            return this;
        }

        public URIBuilder URIBuilder(String fragment) {
            this.fragment = fragment;
            return this;
        }

        public String build() {
            if (this.path == null) {
                return null;
            }
            StringBuilder result = new StringBuilder();
            if (this.scheme != null) {
                result.append(this.scheme).append(":");
            }
            result.append("//");
            if (this.authority != null) {
                result.append(this.authority);
            }
            result.append(UriEscape.escapeUriPath(this.path));
            if (this.query != null) {
                try {
                    String escapedQueryParams = this.escapeQueryParams(this.query);
                    if (!escapedQueryParams.isEmpty()) {
                        result.append("?").append(escapedQueryParams);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.log(Level.WARNING, "Fail to parse params [" + this.query + "]", e);
                }
            }
            if (this.fragment != null) {
                result.append("#").append(UriEscape.escapeUriFragmentId(this.fragment));
            }
            return result.toString();
        }

        private String escapeQueryParams(String query) throws UnsupportedEncodingException {
            Map<String, List<String>> queries = UrlUtil.splitQuery(query);
            StringBuilder result = new StringBuilder();
            for (String key : queries.keySet()) {
                String escapedKey = UriEscape.escapeUriQueryParam(key);
                List<String> values = queries.get(key);
                if (values != null) {
                    for (String value : values) {
                        String escapedValue = value == null ? "" : UriEscape.escapeUriQueryParam(value);
                        result.append(escapedKey).append("=").append(escapedValue).append("&");
                    }
                    continue;
                }
                result.append(escapedKey).append("=").append("").append("&");
            }
            if (result.length() != 0) {
                return result.toString().substring(0, result.length() - 1);
            }
            return "";
        }
    }
}

