/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext.regex;

import com.alibaba.security.util.IOUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class XSSMatcher {
    private static final String REGIX_PATH = "resources/regex.txt";
    private static List<Pattern> PATTERNS;

    public static boolean isSafe(String text) {
        return XSSMatcher.matchText(text, true) == 0;
    }

    public static int matchText(String text) {
        return XSSMatcher.matchText(text, false);
    }

    public static int matchText(String text, boolean stopAtFirst) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        String lowerText = text.toLowerCase();
        int result = 0;
        for (int i = 0; i < PATTERNS.size(); ++i) {
            Pattern p = PATTERNS.get(i);
            if (!p.matcher(lowerText).matches()) continue;
            result |= 1 << i;
            if (!stopAtFirst) continue;
            return result;
        }
        return result;
    }

    static {
        block4: {
            PATTERNS = new ArrayList<Pattern>();
            try {
                InputStream is = XSSMatcher.class.getResourceAsStream(REGIX_PATH);
                if (is != null) {
                    List<String> strRegexs = IOUtils.readLines(is);
                    for (String sp : strRegexs) {
                        PATTERNS.add(Pattern.compile(sp));
                    }
                    break block4;
                }
                throw new RuntimeException("No regex file can be found!");
            }
            catch (Exception e) {
                throw new RuntimeException("An error happened when reading resource file regex.txt.", e);
            }
        }
    }
}

