/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext.model;

import com.alibaba.security.util.trie.SimpleTrieNode;
import com.alibaba.security.util.trie.TrieNode;
import com.alibaba.security.util.trie.converter.HostLetterTrieNodeConverter;
import com.alibaba.security.util.trie.converter.TrieNodeConverter;

public class TreeNode
extends SimpleTrieNode
implements TrieNode {
    private String[] protocols;
    private String prefixpath;

    public TreeNode() {
        super(null, new HostLetterTrieNodeConverter(), true);
    }

    public TreeNode(TrieNode parent, TrieNodeConverter converter, boolean prefix) {
        super(parent, converter, prefix);
    }

    public TreeNode(TrieNode parent, TrieNodeConverter converter, boolean prefix, String[] protocols, String prefixpath) {
        super(parent, converter, prefix);
        this.protocols = protocols;
        this.prefixpath = prefixpath;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    public String getPrefixpath() {
        return this.prefixpath;
    }

    public void setPrefixpath(String prefixpath) {
        this.prefixpath = prefixpath;
    }

    public boolean search(String host, String protocol, String path) {
        if (this.search(host)) {
            if (this.protocols != null) {
                boolean sign = false;
                for (int i = 0; i < this.protocols.length; ++i) {
                    if (!this.protocols[i].equalsIgnoreCase(protocol)) continue;
                    sign = true;
                }
                if (!sign) {
                    return false;
                }
            }
            return this.prefixpath == null || path != null && path.indexOf(this.prefixpath) == 0;
        }
        return false;
    }

    public boolean insert(char[] children, String[] protocols, String prefixpath) {
        return this.insert(children, null, protocols, prefixpath);
    }

    public boolean insert(char[] children, TreeNode parent, String[] protocols, String prefixpath) {
        if (parent == null) {
            return false;
        }
        if (children != null) {
            int index = children.length - 1;
            if (index < 0) {
                return false;
            }
            TreeNode parentNode = parent;
            TreeNode childNode = null;
            while (index >= 0) {
                int theIndex = parent.isPrefix() ? children.length - 1 - index : index;
                char last = children[theIndex];
                int pos = this.getTrieHandler().getPos(last);
                if (pos == -1) {
                    parentNode.setWildcard(true);
                    parentNode.setProtocols(protocols);
                    parentNode.setPrefixpath(prefixpath);
                    return true;
                }
                if (pos == -2) {
                    return false;
                }
                childNode = (TreeNode)parentNode.getChildAt(pos);
                if (childNode == null) {
                    childNode = new TreeNode(parentNode, this.getTrieHandler(), parent.isPrefix());
                    parentNode.addChild(pos, childNode);
                }
                parentNode = childNode;
                --index;
            }
            parentNode.setTerminal(true);
            return true;
        }
        return false;
    }
}

