/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext.model;

import com.alibaba.security.xss.richtext.handler.TagProcessHandler;
import com.alibaba.security.xss.richtext.model.Action;
import com.alibaba.security.xss.richtext.model.Attribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Tag {
    private String name;
    private String attrRef;
    private Map<String, Attribute> allowedAttributes = new HashMap<String, Attribute>();
    private List<String> allowedAttrNameStart = new ArrayList<String>();
    public Action action;
    private TagProcessHandler actionHandler;

    public List<String> getAllowedAttrNameStart() {
        return this.allowedAttrNameStart;
    }

    public void setAllowedAttrNameStart(List<String> allowedAttrNameStart) {
        this.allowedAttrNameStart = allowedAttrNameStart;
    }

    public Tag(String name) {
        this.name = name;
    }

    public String getAttrRef() {
        return this.attrRef;
    }

    public void setAttrRef(String attrRef) {
        this.attrRef = attrRef;
    }

    public Map<String, Attribute> getAllowedAttributes() {
        return this.allowedAttributes;
    }

    public void setAllowedAttributes(Map<String, Attribute> allowedAttributes) {
        if (allowedAttributes != null) {
            this.allowedAttributes = allowedAttributes;
        }
    }

    public Attribute getAttributeByName(String name) {
        return this.allowedAttributes.get(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String[] getAttributes() {
        String[] atts = null;
        if (this.allowedAttributes != null && this.allowedAttributes.size() > 0) {
            atts = new String[this.allowedAttributes.size()];
            Set<String> key = this.allowedAttributes.keySet();
            int i = 0;
            for (String string : key) {
                atts[i++] = string;
            }
        }
        return atts;
    }

    public TagProcessHandler getActionHandler() {
        return this.actionHandler;
    }

    public void setActionHandler(TagProcessHandler actionHandler) {
        this.actionHandler = actionHandler;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name + "={");
        if (this.allowedAttributes != null && this.allowedAttributes.size() > 0) {
            Set<String> key = this.allowedAttributes.keySet();
            if (key.size() == 0) {
                return "";
            }
            for (String string : key) {
                sb.append(string);
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)o;
        if (this.name != null ? !this.name.equals(tag.name) : tag.name != null) {
            return false;
        }
        if (this.attrRef != null ? !this.attrRef.equals(tag.attrRef) : tag.attrRef != null) {
            return false;
        }
        if (this.allowedAttributes != null ? !this.allowedAttributes.equals(tag.allowedAttributes) : tag.allowedAttributes != null) {
            return false;
        }
        if (this.allowedAttrNameStart != null ? !this.allowedAttrNameStart.equals(tag.allowedAttrNameStart) : tag.allowedAttrNameStart != null) {
            return false;
        }
        if (this.action != tag.action) {
            return false;
        }
        return this.actionHandler != null ? this.actionHandler.equals(tag.actionHandler) : tag.actionHandler == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.attrRef != null ? this.attrRef.hashCode() : 0);
        result = 31 * result + (this.allowedAttributes != null ? this.allowedAttributes.hashCode() : 0);
        result = 31 * result + (this.allowedAttrNameStart != null ? this.allowedAttrNameStart.hashCode() : 0);
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + (this.actionHandler != null ? this.actionHandler.hashCode() : 0);
        return result;
    }
}

