/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext.impl;

import com.alibaba.securitysdk.cyberneko.html.HTMLConfiguration;
import com.alibaba.securitysdk.org.apache.xerces.xni.parser.XMLInputSource;
import com.alibaba.securitysdk.org.apache.xerces.xni.parser.XMLParseException;
import com.alibaba.securitysdk.org.xml.sax.InputSource;
import com.alibaba.securitysdk.org.xml.sax.SAXException;
import com.alibaba.securitysdk.org.xml.sax.SAXParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class FragmentXppParser
extends HTMLConfiguration {
    protected static final String DOCUMENT_FRAGMENT_PROPERTY = "http://cyberneko.org/html/features/document-fragment";
    protected static final String DEFAULT_ENCODING_PROPERTY = "http://cyberneko.org/html/properties/default-encoding";
    protected static final String DEFAULT_ENCODING_ALGORITHM = "UTF-8";

    public FragmentXppParser() {
        this.setFeature(DOCUMENT_FRAGMENT_PROPERTY, true);
        this.setProperty(DEFAULT_ENCODING_PROPERTY, DEFAULT_ENCODING_ALGORITHM);
        this.fDocumentScanner.setFeature("http://cyberneko.org/html/features/scanner/style/strip-cdata-delims", true);
    }

    public void parse(InputSource source) throws SAXException, IOException {
        try {
            String pubid = source.getPublicId();
            String sysid = source.getSystemId();
            String encoding = source.getEncoding();
            InputStream stream = source.getByteStream();
            Reader reader = source.getCharacterStream();
            XMLInputSource inputSource = new XMLInputSource(pubid, sysid, sysid);
            inputSource.setEncoding(encoding);
            inputSource.setByteStream(stream);
            inputSource.setCharacterStream(reader);
            this.parse(inputSource);
        }
        catch (XMLParseException e) {
            Exception ex = e.getException();
            if (ex != null) {
                throw new SAXParseException(e.getMessage(), null, ex);
            }
            throw new SAXParseException(e.getMessage(), null);
        }
    }
}

