/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext.handler;

import com.alibaba.security.url.safeurl.SafeUrlCheckerImpl;
import com.alibaba.security.xss.richtext.Policy;
import com.alibaba.security.xss.richtext.handler.AttributeProcessHandler;
import com.alibaba.security.xss.richtext.handler.PolicyAdvice;
import com.alibaba.security.xss.richtext.model.Attribute;
import com.alibaba.security.xss.richtext.model.Tag;

public class EmbedSrcAttributeHandler
implements AttributeProcessHandler,
PolicyAdvice {
    private Policy policy;

    @Override
    public void printAttribute(StringBuilder printWriter, String name, String value, Attribute attr, Tag parent, Policy policy) {
        int index = value.indexOf("?");
        if (index != -1) {
            value = value.substring(0, index);
        }
        boolean canAcceptAttr = false;
        if (policy.strictUrlCheck()) {
            canAcceptAttr = SafeUrlCheckerImpl.SafeUrlCheckerHolder.instance.getSafeUrlWithStrictStrategy(value) != null;
        } else if (value.startsWith("http://") || value.startsWith("https://") || value.startsWith("//")) {
            canAcceptAttr = SafeUrlCheckerImpl.SafeUrlCheckerHolder.instance.inWhiteList(value);
        } else if (!value.contains(":")) {
            canAcceptAttr = true;
        }
        if (canAcceptAttr) {
            printWriter.append(' ');
            printWriter.append(name);
            printWriter.append("=\"");
            this.printAttributeValue(printWriter, value);
            printWriter.append('\"');
        }
    }

    private void printAttributeValue(StringBuilder printWriter, String text) {
        int length = text.length();
        for (int j = 0; j < length; ++j) {
            char c = text.charAt(j);
            if (c == '\"') {
                printWriter.append("&quot;");
                continue;
            }
            printWriter.append(c);
        }
    }

    @Override
    public void setPolicy(Policy policy) {
        this.policy = policy;
    }
}

