/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext;

import com.alibaba.security.resource.richtext.loader.RichtextXmlPolicyLoader;
import com.alibaba.security.xss.richtext.PolicyException;
import com.alibaba.security.xss.richtext.handler.AttributeProcessHandler;
import com.alibaba.security.xss.richtext.handler.CommonStyleAttributeHandler;
import com.alibaba.security.xss.richtext.handler.EmbedSrcAttributeHandler;
import com.alibaba.security.xss.richtext.handler.StyleTagDefaultHandelr;
import com.alibaba.security.xss.richtext.handler.TagProcessHandler;
import com.alibaba.security.xss.richtext.model.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Policy {
    public static final boolean DEFAULT_ENABLE_NAME_SPACE = true;
    public static final boolean DEFAULT_REMOVE_ATTR_IF_EMPTY = true;
    private int maxInputSize = 10000000;
    private int maxCssInputSize = 100000;
    private boolean enableStyleScan = true;
    private boolean enableNamespace = true;
    private boolean removeComment = false;
    private boolean attrsLower = true;
    private boolean elemsLower = true;
    private boolean usePurifier = false;
    private boolean usePreXMLValid = true;
    private boolean removeAttrIfEmpty = true;
    private boolean strictUrlCheck = true;
    private Map<String, String> directives;
    private Map<String, Tag> tagRules;
    private static Map<String, AttributeProcessHandler> defaultAttrHandler = new HashMap<String, AttributeProcessHandler>();
    private static Map<String, TagProcessHandler> defaultTagHandler = new HashMap<String, TagProcessHandler>();
    private static List<String> defaultActionTag = new ArrayList<String>();
    private static Map<CachedProcessHandlerKey, TagProcessHandler> cacheTagProcessHandlerMap = new ConcurrentHashMap<CachedProcessHandlerKey, TagProcessHandler>();
    private static Map<CachedProcessHandlerKey, AttributeProcessHandler> cacheAttrProcessHandlerMap = new ConcurrentHashMap<CachedProcessHandlerKey, AttributeProcessHandler>();

    private Policy() {
    }

    public static Policy newPolicy() {
        return new Policy();
    }

    public static Policy newPolicy(InputStream is) throws PolicyException {
        try {
            return new RichtextXmlPolicyLoader(is).load();
        }
        catch (ParserConfigurationException e) {
            throw new PolicyException(e);
        }
        catch (SAXException e) {
            throw new PolicyException(e);
        }
        catch (IOException e) {
            throw new PolicyException(e);
        }
    }

    public static Policy getLoosePolicyInstance() throws PolicyException {
        return Policy.getInternalDefinePolicyInstance("resources/loose-xss.xml");
    }

    public static Policy getStrictPolicyInstance() throws PolicyException {
        return Policy.getInternalDefinePolicyInstance("resources/strict-xss.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Policy getInternalDefinePolicyInstance(String uri) throws PolicyException {
        InputStream is = null;
        try {
            is = Policy.class.getResourceAsStream(uri);
            Policy policy = Policy.newPolicy(is);
            return policy;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Policy getCustomerPolicyInstance(InputStream is) throws PolicyException {
        return Policy.newPolicy(is);
    }

    public boolean strictUrlCheck() {
        return this.strictUrlCheck;
    }

    public void setStrictUrlCheck(boolean strictUrlCheck) {
        this.strictUrlCheck = strictUrlCheck;
    }

    public String toAttrsCase(String s) {
        if (this.attrsLower) {
            return s.toLowerCase();
        }
        return s.toUpperCase();
    }

    public String toElemsCase(String s) {
        if (this.elemsLower) {
            return s.toLowerCase();
        }
        return s.toUpperCase();
    }

    public int getMaxInputSize() {
        return this.maxInputSize;
    }

    public void setMaxInputSize(int maxInputSize) {
        this.maxInputSize = maxInputSize;
    }

    public int getMaxCssInputSize() {
        return this.maxCssInputSize;
    }

    public void setMaxCssInputSize(int maxCssInputSize) {
        this.maxCssInputSize = maxCssInputSize;
    }

    public boolean isEnableStyleScan() {
        return this.enableStyleScan;
    }

    public void setEnableStyleScan(boolean enableStyleScan) {
        this.enableStyleScan = enableStyleScan;
    }

    public boolean isEnableNamespace() {
        return this.enableNamespace;
    }

    public void setEnableNamespace(boolean enableNamespace) {
        this.enableNamespace = enableNamespace;
    }

    public boolean isRemoveComment() {
        return this.removeComment;
    }

    public void setRemoveComment(boolean removeComment) {
        this.removeComment = removeComment;
    }

    public boolean isAttrsLower() {
        return this.attrsLower;
    }

    public void setAttrsLower(boolean attrsLower) {
        this.attrsLower = attrsLower;
    }

    public boolean isElemsLower() {
        return this.elemsLower;
    }

    public void setElemsLower(boolean elemsLower) {
        this.elemsLower = elemsLower;
    }

    public boolean isUsePurifier() {
        return this.usePurifier;
    }

    public void setUsePurifier(boolean usePurifier) {
        this.usePurifier = usePurifier;
    }

    public boolean isUsePreXMLValid() {
        return this.usePreXMLValid;
    }

    public void setUsePreXMLValid(boolean usePreXMLValid) {
        this.usePreXMLValid = usePreXMLValid;
    }

    public boolean isRemoveAttrIfEmpty() {
        return this.removeAttrIfEmpty;
    }

    public void setDirectives(Map<String, String> directives) {
        this.directives = directives;
    }

    public void setTagRules(Map<String, Tag> tagRules) {
        this.tagRules = tagRules;
    }

    public boolean removeAttrIfEmpty() {
        return this.removeAttrIfEmpty;
    }

    public void setRemoveAttrIfEmpty(boolean removeAttrIfEmpty) {
        this.removeAttrIfEmpty = removeAttrIfEmpty;
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public Map<String, Tag> getTagRules() {
        return this.tagRules;
    }

    public static Map<String, AttributeProcessHandler> getDefaultAttrHandler() {
        return defaultAttrHandler;
    }

    public static Map<String, TagProcessHandler> getDefaultTagHandler() {
        return defaultTagHandler;
    }

    public static List<String> getDefaultActionTag() {
        return defaultActionTag;
    }

    public static Map<CachedProcessHandlerKey, TagProcessHandler> getCacheTagProcessHandlerMap() {
        return cacheTagProcessHandlerMap;
    }

    public static Map<CachedProcessHandlerKey, AttributeProcessHandler> getCacheAttrProcessHandlerMap() {
        return cacheAttrProcessHandlerMap;
    }

    static {
        defaultTagHandler.put("style", new StyleTagDefaultHandelr());
        defaultActionTag.add("style");
        defaultAttrHandler.put("embed.src", new EmbedSrcAttributeHandler());
        defaultAttrHandler.put("common.style", new CommonStyleAttributeHandler());
    }

    public static class CachedProcessHandlerKey {
        private final ClassLoader classLoader;
        private final String className;

        public CachedProcessHandlerKey(String className) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            this.className = className;
        }

        public CachedProcessHandlerKey(ClassLoader classLoader, String className) {
            this.classLoader = classLoader;
            this.className = className;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CachedProcessHandlerKey)) {
                return false;
            }
            CachedProcessHandlerKey that = (CachedProcessHandlerKey)o;
            if (this.classLoader != null ? !this.classLoader.equals(that.classLoader) : that.classLoader != null) {
                return false;
            }
            return this.className != null ? this.className.equals(that.className) : that.className == null;
        }

        public int hashCode() {
            int result = this.classLoader != null ? this.classLoader.hashCode() : 0;
            result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
            return result;
        }
    }
}

