/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.checker;

import com.alibaba.security.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XSSCheckRules {
    private static final Logger logger = Logger.getLogger(XSSCheckRules.class.getName());
    private static final String CUSTOM_XML = "/security/custom-xss-rules.xml";
    private static final List<Pattern> patterns = new ArrayList<Pattern>();
    private static final List<String> blackTags = new ArrayList<String>();
    private static final List<String> blackAttributes = new ArrayList<String>();

    private static void initFromXML() {
        try {
            Document document = XSSCheckRules.parseXML();
            if (document != null) {
                Element root = document.getDocumentElement();
                NodeList blacktags = root.getElementsByTagName("blacktags");
                for (int i = 0; i < blacktags.getLength(); ++i) {
                    Element blacktag = (Element)blacktags.item(i);
                    NodeList tags = blacktag.getElementsByTagName("tag");
                    if (tags.getLength() > 0) {
                        blackTags.clear();
                    }
                    for (int j = 0; j < tags.getLength(); ++j) {
                        Element tag = (Element)tags.item(j);
                        String value = tag.getAttribute("value");
                        if (value.trim().isEmpty()) continue;
                        blackTags.add(value.trim());
                    }
                }
                NodeList blackattributes = root.getElementsByTagName("blackattributes");
                for (int i = 0; i < blackattributes.getLength(); ++i) {
                    Element blackattribute = (Element)blackattributes.item(i);
                    NodeList attributes = blackattribute.getElementsByTagName("attribute");
                    if (attributes.getLength() > 0) {
                        blackAttributes.clear();
                    }
                    for (int j = 0; j < attributes.getLength(); ++j) {
                        Element attribute = (Element)attributes.item(j);
                        String value = attribute.getAttribute("value");
                        if (value.trim().isEmpty()) continue;
                        blackAttributes.add(value.trim());
                    }
                }
                NodeList patternRules = root.getElementsByTagName("patterns");
                for (int i = 0; i < patternRules.getLength(); ++i) {
                    Element patternRule = (Element)patternRules.item(i);
                    NodeList pattern = patternRule.getElementsByTagName("pattern");
                    for (int j = 0; j < pattern.getLength(); ++j) {
                        Element attribute = (Element)pattern.item(j);
                        String value = attribute.getAttribute("value");
                        if (value.isEmpty()) continue;
                        patterns.add(Pattern.compile(value));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warning("Parse custom-xss-rules.xml failed, use default. message: " + e.getMessage());
        }
    }

    private static Document parseXML() throws IOException, SAXException, ParserConfigurationException {
        InputStream inputSteam = ResourceUtil.getResourceInputSteam(CUSTOM_XML, XSSCheckRules.class);
        if (inputSteam != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(inputSteam);
        }
        return null;
    }

    private static void initPatterns() {
        patterns.add(Pattern.compile("=.*?javascript\\s*?:"));
        patterns.add(Pattern.compile("=.*?vbscript\\s*?:"));
        patterns.add(Pattern.compile("[/\\s]+?onload\\s*?:"));
        patterns.add(Pattern.compile("[/\\s]+?onload\\s*?="));
        patterns.add(Pattern.compile("@import\\s+?"));
        patterns.add(Pattern.compile("=\\s*?eval.*?\\(.*?\\)"));
        patterns.add(Pattern.compile("=\\s*?'eval.*?\\(.*?\\)"));
        patterns.add(Pattern.compile("top\\[.*?\\]\\(.*?\\)"));
        patterns.add(Pattern.compile("\\(atob\\("));
        patterns.add(Pattern.compile("[=\\[\\(\\{]eval.*?\\(.*?\\)"));
        patterns.add(Pattern.compile("\\(eval\\)"));
        patterns.add(Pattern.compile("[^a-z]+?eval\\("));
        patterns.add(Pattern.compile("=javascript&colon;"));
        patterns.add(Pattern.compile("<embed\\s+?src=[a-z/]*?"));
        patterns.add(Pattern.compile("[/\\s]+?onerror\\s*?="));
        patterns.add(Pattern.compile("[/\\s]+?onclick\\s*?="));
        patterns.add(Pattern.compile("[/\\s]+?ondblclick\\s*?="));
        patterns.add(Pattern.compile("data:text/html\\s*?;\\s*?base64\\s*?"));
        patterns.add(Pattern.compile("<script[/\\s]+?src="));
    }

    private static void initBlackTags() {
        blackTags.add("script");
    }

    private static void initBlackAttributes() {
        blackAttributes.add("onabort");
        blackAttributes.add("onabsolutedeviceorientation");
        blackAttributes.add("onactivate");
        blackAttributes.add("onafterprint");
        blackAttributes.add("onafterscriptexecute");
        blackAttributes.add("onafterupdate");
        blackAttributes.add("onanimationend");
        blackAttributes.add("onanimationiteration");
        blackAttributes.add("onanimationstart");
        blackAttributes.add("onappinstalled");
        blackAttributes.add("onautocomplete");
        blackAttributes.add("onautocompleteerror");
        blackAttributes.add("onauxclick");
        blackAttributes.add("onbeforeactivate");
        blackAttributes.add("onbeforecopy");
        blackAttributes.add("onbeforecut");
        blackAttributes.add("onbeforedeactivate");
        blackAttributes.add("onbeforeeditfocus");
        blackAttributes.add("onbeforeinstallprompt");
        blackAttributes.add("onbeforepaste");
        blackAttributes.add("onbeforeprint");
        blackAttributes.add("onbeforescriptexecute");
        blackAttributes.add("onbeforeunload");
        blackAttributes.add("onbeforeupdate");
        blackAttributes.add("onblur");
        blackAttributes.add("oncancel");
        blackAttributes.add("oncanplay");
        blackAttributes.add("oncanplaythrough");
        blackAttributes.add("oncellchange");
        blackAttributes.add("onchange");
        blackAttributes.add("onclick");
        blackAttributes.add("onclose");
        blackAttributes.add("oncontextmenu");
        blackAttributes.add("oncontrolselect");
        blackAttributes.add("oncopy");
        blackAttributes.add("oncuechange");
        blackAttributes.add("oncut");
        blackAttributes.add("ondataavailable");
        blackAttributes.add("ondatasetchanged");
        blackAttributes.add("ondatasetcomplete");
        blackAttributes.add("ondblclick");
        blackAttributes.add("ondeactivate");
        blackAttributes.add("ondevicelight");
        blackAttributes.add("ondevicemotion");
        blackAttributes.add("ondeviceorientation");
        blackAttributes.add("ondeviceorientationabsolute");
        blackAttributes.add("ondeviceproximity");
        blackAttributes.add("ondrag");
        blackAttributes.add("ondragend");
        blackAttributes.add("ondragenter");
        blackAttributes.add("ondragexit");
        blackAttributes.add("ondragleave");
        blackAttributes.add("ondragover");
        blackAttributes.add("ondragstart");
        blackAttributes.add("ondrop");
        blackAttributes.add("ondurationchange");
        blackAttributes.add("onelementpainted");
        blackAttributes.add("onembedviewclosed");
        blackAttributes.add("onembedviewopened");
        blackAttributes.add("onemptied");
        blackAttributes.add("onended");
        blackAttributes.add("onerror");
        blackAttributes.add("onerrorupdate");
        blackAttributes.add("onfocus");
        blackAttributes.add("onfocusin");
        blackAttributes.add("onfocusout");
        blackAttributes.add("ongesturechange");
        blackAttributes.add("ongestureend");
        blackAttributes.add("ongesturestart");
        blackAttributes.add("ongotpointercapture");
        blackAttributes.add("onhashchange");
        blackAttributes.add("onhelp");
        blackAttributes.add("oninput");
        blackAttributes.add("oninvalid");
        blackAttributes.add("onkeydown");
        blackAttributes.add("onkeypress");
        blackAttributes.add("onkeyup");
        blackAttributes.add("onlanguagechange");
        blackAttributes.add("onLine");
        blackAttributes.add("onload");
        blackAttributes.add("onloadeddata");
        blackAttributes.add("onloadedmetadata");
        blackAttributes.add("onloadend");
        blackAttributes.add("onloadstart");
        blackAttributes.add("onlostpointercapture");
        blackAttributes.add("onmessage");
        blackAttributes.add("onmessageerror");
        blackAttributes.add("onmousedown");
        blackAttributes.add("onmouseenter");
        blackAttributes.add("onmouseleave");
        blackAttributes.add("onmousemove");
        blackAttributes.add("onmouseout");
        blackAttributes.add("onmouseover");
        blackAttributes.add("onmouseup");
        blackAttributes.add("onmousewheel");
        blackAttributes.add("onmozfullscreenchange");
        blackAttributes.add("onmozfullscreenerror");
        blackAttributes.add("onmozpointerlockchange");
        blackAttributes.add("onmozpointerlockerror");
        blackAttributes.add("onmscontentzoom");
        blackAttributes.add("onmsfullscreenchange");
        blackAttributes.add("onmsfullscreenerror");
        blackAttributes.add("onmsgesturechange");
        blackAttributes.add("onmsgesturedoubletap");
        blackAttributes.add("onmsgestureend");
        blackAttributes.add("onmsgesturehold");
        blackAttributes.add("onmsgesturestart");
        blackAttributes.add("onmsgesturetap");
        blackAttributes.add("onmsinertiastart");
        blackAttributes.add("onmsmanipulationstatechanged");
        blackAttributes.add("onmspointercancel");
        blackAttributes.add("onmspointerdown");
        blackAttributes.add("onmspointerenter");
        blackAttributes.add("onmspointerhover");
        blackAttributes.add("onmspointerleave");
        blackAttributes.add("onmspointermove");
        blackAttributes.add("onmspointerout");
        blackAttributes.add("onmspointerover");
        blackAttributes.add("onmspointerup");
        blackAttributes.add("onmssitemodejumplistitemremoved");
        blackAttributes.add("onmsthumbnailclick");
        blackAttributes.add("onoffline");
        blackAttributes.add("ononline");
        blackAttributes.add("onorientationchange");
        blackAttributes.add("onpagehide");
        blackAttributes.add("onpageshow");
        blackAttributes.add("onpaste");
        blackAttributes.add("onpause");
        blackAttributes.add("onplay");
        blackAttributes.add("onplaying");
        blackAttributes.add("onpointercancel");
        blackAttributes.add("onpointerdown");
        blackAttributes.add("onpointerenter");
        blackAttributes.add("onpointerleave");
        blackAttributes.add("onpointerlockchange");
        blackAttributes.add("onpointerlockerror");
        blackAttributes.add("onpointermove");
        blackAttributes.add("onpointerout");
        blackAttributes.add("onpointerover");
        blackAttributes.add("onpointerup");
        blackAttributes.add("onpopstate");
        blackAttributes.add("onprogress");
        blackAttributes.add("onpropertychange");
        blackAttributes.add("onratechange");
        blackAttributes.add("onreadystatechange");
        blackAttributes.add("onrejectionhandled");
        blackAttributes.add("onreset");
        blackAttributes.add("onresize");
        blackAttributes.add("onrowenter");
        blackAttributes.add("onrowexit");
        blackAttributes.add("onrowsdelete");
        blackAttributes.add("onrowsinserted");
        blackAttributes.add("onscroll");
        blackAttributes.add("onsearch");
        blackAttributes.add("onseeked");
        blackAttributes.add("onseeking");
        blackAttributes.add("onselect");
        blackAttributes.add("onselectionchange");
        blackAttributes.add("onselectstart");
        blackAttributes.add("onshow");
        blackAttributes.add("onstalled");
        blackAttributes.add("onstop");
        blackAttributes.add("onstorage");
        blackAttributes.add("onstoragecommit");
        blackAttributes.add("onsubmit");
        blackAttributes.add("onsuspend");
        blackAttributes.add("ontimeupdate");
        blackAttributes.add("ontoggle");
        blackAttributes.add("ontouchcancel");
        blackAttributes.add("ontouchend");
        blackAttributes.add("ontouchforcechange");
        blackAttributes.add("ontouchmove");
        blackAttributes.add("ontouchstart");
        blackAttributes.add("ontransitionend");
        blackAttributes.add("onunhandledrejection");
        blackAttributes.add("onunload");
        blackAttributes.add("onuserproximity");
        blackAttributes.add("onvisibilitychange");
        blackAttributes.add("onvolumechange");
        blackAttributes.add("onwaiting");
        blackAttributes.add("onwebkitanimationend");
        blackAttributes.add("onwebkitanimationiteration");
        blackAttributes.add("onwebkitanimationstart");
        blackAttributes.add("onwebkitfullscreenchange");
        blackAttributes.add("onwebkitfullscreenerror");
        blackAttributes.add("onwebkitmouseforcechanged");
        blackAttributes.add("onwebkitmouseforcedown");
        blackAttributes.add("onwebkitmouseforceup");
        blackAttributes.add("onwebkitmouseforcewillbegin");
        blackAttributes.add("onwebkitpointerlockchange");
        blackAttributes.add("onwebkitpointerlockerror");
        blackAttributes.add("onwebkittransitionend");
        blackAttributes.add("onwheel");
        blackAttributes.add("onhaschange");
        blackAttributes.add("onredo");
        blackAttributes.add("onformchange");
        blackAttributes.add("onforminput");
        blackAttributes.add("onafterprintNew");
        blackAttributes.add("onerrorNew");
        blackAttributes.add("onhaschangeNew");
        blackAttributes.add("onmessageNew");
        blackAttributes.add("onofflineNew");
        blackAttributes.add("ononlineNew");
        blackAttributes.add("onpagehideNew");
        blackAttributes.add("onpageshowNew");
        blackAttributes.add("onpopstateNew");
        blackAttributes.add("onredoNew");
        blackAttributes.add("onresizeNew");
        blackAttributes.add("onstorageNew");
        blackAttributes.add("onundoNew");
        blackAttributes.add("onundo");
        blackAttributes.add("onunloadNew");
        blackAttributes.add("oncontextmenuNew");
        blackAttributes.add("onformchangeNew");
        blackAttributes.add("onforminputNew");
        blackAttributes.add("oninputNew");
        blackAttributes.add("oninvalidNew");
        blackAttributes.add("ondragNew");
        blackAttributes.add("ondragendNew");
        blackAttributes.add("ondragenterNew");
        blackAttributes.add("ondragoverNew");
        blackAttributes.add("ondragstartNew");
        blackAttributes.add("ondropNew");
        blackAttributes.add("onmousewheelNew");
        blackAttributes.add("onscrollNew");
        blackAttributes.add("oncanplayNew");
        blackAttributes.add("onemptiedNew");
        blackAttributes.add("onendedNew");
        blackAttributes.add("onloadedmetadataNew");
        blackAttributes.add("onloadstartNew");
        blackAttributes.add("onplayNew");
        blackAttributes.add("onplayingNew");
        blackAttributes.add("onratechangeNew");
        blackAttributes.add("onseekedNew");
        blackAttributes.add("ontimeupdateNew");
        blackAttributes.add("onshowNew");
        blackAttributes.add("onstart");
        blackAttributes.add("onfinish");
        blackAttributes.add("FSCommand");
        blackAttributes.add("onBegin");
        blackAttributes.add("onBounce");
        blackAttributes.add("onDragDrop");
        blackAttributes.add("onEnd");
        blackAttributes.add("onFilterChange");
        blackAttributes.add("onFinish");
        blackAttributes.add("onLayoutComplete");
        blackAttributes.add("onLoseCapture");
        blackAttributes.add("onMediaComplete");
        blackAttributes.add("onMediaError");
        blackAttributes.add("onMove");
        blackAttributes.add("onMoveEnd");
        blackAttributes.add("onMoveStart");
        blackAttributes.add("onOutOfSync");
        blackAttributes.add("onRepeat");
        blackAttributes.add("onResizeEnd");
        blackAttributes.add("onResizeStart");
        blackAttributes.add("onResume");
        blackAttributes.add("onReverse");
        blackAttributes.add("onRowsEnter");
        blackAttributes.add("onRowDelete");
        blackAttributes.add("onRowInserted");
        blackAttributes.add("onSeek");
        blackAttributes.add("onStart");
        blackAttributes.add("onSyncRestored");
        blackAttributes.add("onTimeError");
        blackAttributes.add("onTrackChange");
        blackAttributes.add("onURLFlip");
        blackAttributes.add("seekSegmentTime");
        blackAttributes.add("srcdoc");
        blackAttributes.add("http-equiv");
    }

    public static List<String> blackTags() {
        return blackTags;
    }

    public static List<String> blackAttributes() {
        return blackAttributes;
    }

    public static List<Pattern> patterns() {
        return patterns;
    }

    static {
        XSSCheckRules.initPatterns();
        XSSCheckRules.initBlackTags();
        XSSCheckRules.initBlackAttributes();
        XSSCheckRules.initFromXML();
    }
}

