/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util.asapi.encoder;

import com.alibaba.security.util.asapi.Codec;
import com.alibaba.security.util.asapi.Encoder;
import com.alibaba.security.util.asapi.codec.CSSCodec;
import com.alibaba.security.util.asapi.codec.HTMLEntitiesCodec;
import com.alibaba.security.util.asapi.codec.JSONCodec;
import com.alibaba.security.util.asapi.codec.JavaScriptCodec;
import com.alibaba.security.util.crypto.Base62;
import com.alibaba.security.util.crypto.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultEncoder
implements Encoder {
    private static final char[] IMMUNE_HTML = new char[]{',', '.', '-', '_', ' '};
    private static final char[] IMMUNE_HTMLATTR = new char[]{',', '.', '-', '_'};
    private static final char[] IMMUNE_CSS = new char[0];
    private static final char[] IMMUNE_JAVASCRIPT = new char[]{',', '.', '_'};
    private static final char[] IMMUNE_XML = new char[]{',', '.', '-', '_', ' '};
    private static final char[] IMMUNE_XMLATTR = new char[]{',', '.', '-', '_'};
    private static final DefaultEncoder INSTANCE = new DefaultEncoder();
    private static List<Codec> codecs = new ArrayList<Codec>();
    private static CSSCodec csscodec = new CSSCodec();
    private static HTMLEntitiesCodec htmlcodec = HTMLEntitiesCodec.HTML40;
    private static HTMLEntitiesCodec xmlcodec = HTMLEntitiesCodec.XML;
    private static JavaScriptCodec jscodec = new JavaScriptCodec();
    private static JSONCodec jsoncidec = new JSONCodec();

    @Override
    public String canonicalize(String input) {
        if (input == null) {
            return null;
        }
        String working = input;
        Codec codecFound = null;
        int mixedCount = 1;
        int foundCount = 0;
        boolean clean = false;
        while (!clean) {
            clean = true;
            Iterator<Codec> iterator = codecs.iterator();
            while (iterator.hasNext()) {
                String old = working;
                Codec codec = iterator.next();
                if (old.equals(working = codec.decode(working))) continue;
                if (codecFound != null && codecFound != codec) {
                    ++mixedCount;
                }
                codecFound = codec;
                if (clean) {
                    ++foundCount;
                }
                clean = false;
            }
        }
        if (foundCount >= 2 && mixedCount > 1 || foundCount >= 2 || mixedCount > 1) {
            // empty if block
        }
        return working;
    }

    @Override
    public String encodeForCSS(String input) {
        return csscodec.encode(IMMUNE_CSS, input);
    }

    @Override
    public String decodeFromCSS(String input) {
        return csscodec.decode(input);
    }

    @Override
    public String encodeForHTML(String input) {
        if (input == null) {
            return null;
        }
        return htmlcodec.encode(IMMUNE_HTML, input);
    }

    @Override
    public String decodeFromHTML(String input) {
        if (input == null) {
            return null;
        }
        return htmlcodec.decode(input);
    }

    @Override
    public String encodeForHTMLAttribute(String input) {
        if (input == null) {
            return null;
        }
        return htmlcodec.encode(IMMUNE_HTMLATTR, input);
    }

    @Override
    public String encodeForJavaScript(String input) {
        if (input == null) {
            return null;
        }
        return jscodec.encode(IMMUNE_JAVASCRIPT, input);
    }

    @Override
    public String decodeFromJavaScript(String input) {
        if (input == null) {
            return null;
        }
        return jscodec.decode(input);
    }

    @Override
    public String encodeForXML(String input) {
        if (input == null) {
            return null;
        }
        return xmlcodec.encode(IMMUNE_XML, input);
    }

    @Override
    public String encodeForXMLAttribute(String input) {
        if (input == null) {
            return null;
        }
        return xmlcodec.encode(IMMUNE_XMLATTR, input);
    }

    @Override
    public String encodeForURL(String input, String enc) throws UnsupportedEncodingException {
        if (input == null) {
            return null;
        }
        return URLEncoder.encode(input, enc);
    }

    @Override
    public String decodeFromURL(String input, String enc) throws UnsupportedEncodingException {
        if (input == null) {
            return null;
        }
        String canonical = this.canonicalize(input);
        return URLDecoder.decode(canonical, enc);
    }

    @Override
    public String encodeForBase64(byte[] input) {
        return Base64.encode(input);
    }

    @Override
    public byte[] decodeFromBase64(String input) {
        return Base64.decodeBytes(input.getBytes());
    }

    @Override
    public String encodeForBase62(String input) {
        return Base62.encode(input);
    }

    @Override
    public String decodeFromBase62(String input) {
        return Base62.decode(input);
    }

    @Override
    public String encodeForJSON(String input) {
        return jsoncidec.encode(IMMUNE_JAVASCRIPT, input);
    }

    @Override
    public String decodeFromJSON(String input) {
        return jsoncidec.decode(input);
    }
}

