/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util.asapi.codec;

import com.alibaba.security.util.PushbackableString;
import com.alibaba.security.util.asapi.Codec;

public class JSONCodec
extends Codec {
    @Override
    public String encode(char[] immune, String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Codec.containsCharacter(c, immune) || Codec.getHex(c) == null) {
                sb.append(c);
                continue;
            }
            String hex = Integer.toHexString(c);
            String pad = "\\u0000".substring(0, 6 - hex.length());
            sb.append(pad).append(hex);
        }
        return sb.toString();
    }

    @Override
    public String decode(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char[] ch = input.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (c == '\\') {
                c = ch[++i];
                int len = 0;
                if (c != 'u' && c != 'U') {
                    return null;
                }
                len = 4;
                int val = 0;
                for (int j = 0; j < len; ++j) {
                    if (!PushbackableString.isHexDigit(c = ch[++i])) {
                        return null;
                    }
                    int charVal = c >= '0' && c <= '9' ? c - 48 : (c >= 'a' && c <= 'z' ? c - 97 + 10 : c - 65 + 10);
                    val += charVal << 4 * (len - 1 - j);
                }
                if (Character.isValidCodePoint(val)) {
                    sb.append((char)val);
                    continue;
                }
                return null;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public int decodeChar(PushbackableString input) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public String encodeChar(char[] immune, char c) {
        throw new UnsupportedOperationException("Method not implemented.");
    }
}

