/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;

public class StringEscapeUtils {
    private static final CharSequenceTranslator Translator = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.BASIC_UNESCAPE()), new LookupTranslator((CharSequence[][])EntityArrays.ISO8859_1_UNESCAPE()), new LookupTranslator((CharSequence[][])EntityArrays.HTML40_EXTENDED_UNESCAPE()), new NumericEntityUnescaper()});

    public static String unescapeHtml(String input) {
        return Translator.translate((CharSequence)input);
    }

    static class NumericEntityUnescaper
    extends CharSequenceTranslator {
        NumericEntityUnescaper() {
        }

        public int translate(CharSequence input, int index, Writer out) throws IOException {
            int seqEnd = input.length();
            if (input.charAt(index) == '&' && index < seqEnd - 2 && input.charAt(index + 1) == '#') {
                int end;
                int start = index + 2;
                boolean isHex = false;
                char firstChar = input.charAt(start);
                if (firstChar == 'x' || firstChar == 'X') {
                    isHex = true;
                    if (++start == seqEnd) {
                        return 0;
                    }
                }
                for (end = start; end < seqEnd && (input.charAt(end) >= '0' && input.charAt(end) <= '9' || input.charAt(end) >= 'a' && input.charAt(end) <= 'f' || input.charAt(end) >= 'A' && input.charAt(end) <= 'F'); ++end) {
                }
                boolean semiNext = end != seqEnd;
                try {
                    char endChar;
                    int entityValue = isHex ? Integer.parseInt(input.subSequence(start, end).toString(), 16) : Integer.parseInt(input.subSequence(start, end).toString(), 10);
                    if (entityValue > 65535) {
                        char[] chrs = Character.toChars(entityValue);
                        out.write(chrs[0]);
                        out.write(chrs[1]);
                    } else {
                        out.write(entityValue);
                    }
                    if (semiNext && (endChar = input.charAt(end)) != ';') {
                        out.write(endChar);
                    }
                    return 2 + end - start + (isHex ? 1 : 0) + (semiNext ? 1 : 0);
                }
                catch (IllegalArgumentException nfe) {
                    return 0;
                }
            }
            return 0;
        }
    }
}

