/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util;

import com.alibaba.security.util.ClassUtils;
import com.alibaba.security.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.net.InetAddress;

public class InetAddressResolver {
    private static final String HOLDER_FIELD_NAME = "holder";
    private static final String HOLDER_CLASS = "java.net.InetAddress$InetAddressHolder";
    private static final String HOLDER_HOSTNAME_FIELD_NAME = "hostName";
    private volatile Class<? extends InetAddress> cachedInetAddressClass;
    private Field cachedHolderField;
    private Field cachedHostNameFiled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findInetAddressHoldingHostName(InetAddress inetAddress) {
        InetAddressResolver inetAddressResolver;
        if (inetAddress == null) {
            return null;
        }
        if (this.cachedInetAddressClass == null) {
            inetAddressResolver = this;
            synchronized (inetAddressResolver) {
                if (this.cachedInetAddressClass == null) {
                    this.flushCache(inetAddress);
                }
            }
        }
        if (!this.cachedInetAddressClass.equals(inetAddress.getClass())) {
            inetAddressResolver = this;
            synchronized (inetAddressResolver) {
                if (!this.cachedInetAddressClass.equals(inetAddress.getClass())) {
                    this.flushCache(inetAddress);
                }
            }
        }
        return (String)ReflectionUtils.getNestedFieldValue(inetAddress, this.cachedHolderField, this.cachedHostNameFiled);
    }

    private void flushCache(InetAddress inetAddress) {
        Class<?> tempClass = inetAddress.getClass();
        this.cachedHolderField = ReflectionUtils.findField(tempClass, HOLDER_FIELD_NAME);
        Class<?> holderClass = ClassUtils.forNameQuietly(HOLDER_CLASS, tempClass.getClassLoader());
        this.cachedHostNameFiled = ReflectionUtils.findField(holderClass, HOLDER_HOSTNAME_FIELD_NAME);
        this.cachedInetAddressClass = tempClass;
    }
}

