/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class IOUtils {
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";

    private IOUtils() {
    }

    public static void closeQuietly(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String readToString(String path) throws IOException {
        return IOUtils.readToString(path, null);
    }

    public static String readToString(String path, String charsetName) throws IOException {
        int length;
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(charsetName == null ? DEFAULT_CHARSET_NAME : charsetName);
    }

    public static List<String> readLines(String path) throws IOException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        return IOUtils.readLines(inputStream);
    }

    public static List<String> readLines(String path, String charset) throws IOException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        return IOUtils.readLines(inputStream, charset);
    }

    public static List<String> readLines(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(InputStream input, String charset) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, charset);
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = IOUtils.toBufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static String convertStreamToString(InputStream input, Charset encoding) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = input.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(encoding == null ? Charset.defaultCharset().name() : encoding.name());
    }

    public static String convertStreamToString(InputStream input) throws IOException {
        return IOUtils.convertStreamToString(input, Charset.forName(DEFAULT_CHARSET_NAME));
    }
}

