/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.url.ssrf.policy;

import com.alibaba.security.net.NetHooksEventListener;
import com.alibaba.security.net.SecurityNetHooksProvider;
import com.alibaba.security.url.exception.SSRFThrowableFactory;
import com.alibaba.security.url.ssrf.AliSecurityManager;
import com.alibaba.security.url.ssrf.HostCachePolicy;
import com.alibaba.security.url.ssrf.SSRFNetHooksEventListener;
import com.alibaba.security.url.ssrf.checkcondition.CustomExpirationCacheSSRFNetHooksCheckCondition;
import com.alibaba.security.url.ssrf.checkcondition.CustomExpirationCacheSecurityManagerConnectCheckCondition;
import com.alibaba.security.url.ssrf.checkcondition.ExpirationCacheSSRFNetHooksCheckCondition;
import com.alibaba.security.url.ssrf.checkcondition.ExpirationCacheSecurityManagerConnectCheckCondition;
import com.alibaba.security.url.ssrf.checkcondition.SSRFNetHooksCheckCondition;
import com.alibaba.security.url.ssrf.checkcondition.SecurityManagerConnectCheckCondition;
import com.alibaba.security.url.ssrf.checkcondition.ThreadLocalSSRFNetHooksCheckCondition;
import com.alibaba.security.url.ssrf.checkcondition.ThreadLocalSecurityManagerConnectCheckCondition;
import com.alibaba.security.util.ClassUtils;
import com.alibaba.security.util.JdkVersion;
import com.alibaba.security.util.expiringmap.ExpiringMap;
import com.alibaba.security.util.expiringmap.ExpiringSet;

public class CompatibleSsrfCheckerRegister {
    public static final ExpiringSet<String> EXPIRING_SET = CompatibleSsrfCheckerRegister.initExpiringSet();
    public static final ExpiringSet<String> CUSTOM_EXPIRING_SET = CompatibleSsrfCheckerRegister.initExpiringSet();
    private static final String NET_HOOKS_PROVIDER_CLASS_PATH = "sun.net.NetHooks.Provider";
    private static Boolean ENABLE_NET_HOOKS = false;
    private static Boolean ENABLE_SECURITY_MANAGER_CHECK = false;

    public static void start() {
        CompatibleSsrfCheckerRegister.initiate();
        if (ENABLE_NET_HOOKS.booleanValue()) {
            SSRFNetHookCheckingFlagHolder.NEED_CHECKING.set(true);
        } else if (ENABLE_SECURITY_MANAGER_CHECK.booleanValue()) {
            SSRFSecurtiyManagerCheckingFlagHolder.NEED_CHECKING.set(true);
        }
    }

    public static void startCachedNetHooking(String host, boolean isCustomThrowable) {
        CompatibleSsrfCheckerRegister.initiate();
        if (ENABLE_NET_HOOKS.booleanValue() || ENABLE_SECURITY_MANAGER_CHECK.booleanValue()) {
            if (isCustomThrowable) {
                CUSTOM_EXPIRING_SET.add(host);
            } else {
                EXPIRING_SET.add(host);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initiate() {
        if (ENABLE_NET_HOOKS.booleanValue() || ENABLE_SECURITY_MANAGER_CHECK.booleanValue()) return;
        String string = NET_HOOKS_PROVIDER_CLASS_PATH;
        synchronized (NET_HOOKS_PROVIDER_CLASS_PATH) {
            if (JdkVersion.getMajorJavaVersion() >= 2) {
                if (ENABLE_NET_HOOKS.booleanValue()) return;
                try {
                    CompatibleSsrfCheckerRegister.registerNetHooksProviderListener(new SSRFNetHooksEventListener(new SSRFNetHooksCheckCondition[0]));
                    if (!ClassUtils.isPresent(NET_HOOKS_PROVIDER_CLASS_PATH, ClassUtils.getDefaultClassLoader())) return;
                    SSRFNetHooksEventListener listener = new SSRFNetHooksEventListener(CompatibleSsrfCheckerRegister.getDefaultSSRFNetHooksCheckCondition());
                    SecurityNetHooksProvider.registerListener(listener);
                }
                finally {
                    ENABLE_NET_HOOKS = true;
                }
            }
            if (ENABLE_SECURITY_MANAGER_CHECK.booleanValue()) return;
            try {
                SecurityManager currentSecurityManager = System.getSecurityManager();
                if (currentSecurityManager instanceof AliSecurityManager) return;
                System.setSecurityManager(new AliSecurityManager(currentSecurityManager, CompatibleSsrfCheckerRegister.getDefaultSecurityManagerConnectCondition()));
            }
            finally {
                ENABLE_SECURITY_MANAGER_CHECK = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void registerNetHooksProviderListener(NetHooksEventListener listener) {
        if (ClassUtils.isPresent(NET_HOOKS_PROVIDER_CLASS_PATH, ClassUtils.getDefaultClassLoader())) {
            SecurityNetHooksProvider.registerListener(listener);
        }
    }

    private static SSRFNetHooksCheckCondition[] getDefaultSSRFNetHooksCheckCondition() {
        return new SSRFNetHooksCheckCondition[]{new ThreadLocalSSRFNetHooksCheckCondition(), new ExpirationCacheSSRFNetHooksCheckCondition(), new CustomExpirationCacheSSRFNetHooksCheckCondition()};
    }

    private static SecurityManagerConnectCheckCondition[] getDefaultSecurityManagerConnectCondition() {
        return new SecurityManagerConnectCheckCondition[]{new ThreadLocalSecurityManagerConnectCheckCondition(), new ExpirationCacheSecurityManagerConnectCheckCondition(), new CustomExpirationCacheSecurityManagerConnectCheckCondition()};
    }

    public static void stop() {
        if (ENABLE_NET_HOOKS.booleanValue()) {
            SSRFNetHookCheckingFlagHolder.NEED_CHECKING.set(false);
        } else if (ENABLE_SECURITY_MANAGER_CHECK.booleanValue()) {
            SSRFSecurtiyManagerCheckingFlagHolder.NEED_CHECKING.set(false);
        }
    }

    private static ExpiringSet<String> initExpiringSet() {
        return HostCachePolicy.expiringSet();
    }

    private static ExpiringMap<String, SSRFThrowableFactory> initExpiringMap() {
        return HostCachePolicy.expiringMap();
    }

    public static class SSRFSecurtiyManagerCheckingFlagHolder {
        public static final ThreadLocal<Boolean> NEED_CHECKING = new ThreadLocal<Boolean>(){

            @Override
            public Boolean initialValue() {
                return false;
            }
        };
    }

    public static class SSRFNetHookCheckingFlagHolder {
        public static final ThreadLocal<Boolean> NEED_CHECKING = new ThreadLocal<Boolean>(){

            @Override
            public Boolean initialValue() {
                return false;
            }
        };
    }
}

