/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.url.ssrf.http;

import com.alibaba.security.url.SSRFChecker;
import com.alibaba.security.url.ssrf.http.SecurityRedirectStrategy;
import com.alibaba.security.util.AssertUtil;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.DefaultSecurityRedirectStrategy;
import org.apache.http.protocol.HttpContext;

public abstract class AbstractSecurityRedirectStrategy
extends DefaultSecurityRedirectStrategy
implements SecurityRedirectStrategy {
    private static final Logger LOGGER = Logger.getLogger(AbstractSecurityRedirectStrategy.class.getName());
    protected SSRFChecker ssrfChecker;
    private SecurityRedirectStrategy.CheckMethod checkMethod;

    AbstractSecurityRedirectStrategy(SecurityRedirectStrategy.CheckMethod checkMethod) {
        super(new String[]{"GET", "POST", "HEAD"});
        this.checkMethod = checkMethod;
    }

    @Override
    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        AssertUtil.assertNotNull(this.ssrfChecker, "init method should be invoked before you using this strategy");
        URI uri = this.getLocationURI(request, response, context);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("check ssrf attack: " + uri);
        }
        this.checkSSRFAttack(uri);
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("HEAD")) {
            return new HttpHead(uri);
        }
        if (method.equalsIgnoreCase("GET")) {
            return new HttpGet(uri);
        }
        int status = response.getStatusLine().getStatusCode();
        return status == 307 ? RequestBuilder.copy((HttpRequest)request).setUri(uri).build() : new HttpGet(uri);
    }

    public void init(SSRFChecker ssrfChecker) {
        this.ssrfChecker = ssrfChecker;
    }

    public SecurityRedirectStrategy.CheckMethod getCheckMethod() {
        return this.checkMethod;
    }

    abstract void checkSSRFAttack(URI var1);
}

