/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.ssrf.matcher;

import com.alibaba.security.resource.ssrf.loader.formatter.SSRFMatcherParamsFormatters;
import com.alibaba.security.resource.ssrf.matcher.SsrfMatchable;
import com.alibaba.security.url.model.SSRFMatcherEnum;
import com.alibaba.security.util.matcher.DelegateStringMatcher;
import com.alibaba.security.util.matcher.SetBasedStringMatcher;
import com.alibaba.security.util.matcher.StringMatcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SsrfMatcher
implements SsrfMatchable {
    private Map<SSRFMatcherEnum, StringMatcher> rootNodeMap;
    private Map<SSRFMatcherEnum, StringMatcher> observedRootNodeMap;

    public SsrfMatcher(Map<SSRFMatcherEnum, StringMatcher> rootNodeMap, Map<SSRFMatcherEnum, StringMatcher> observedRootNodeMap) {
        this.rootNodeMap = rootNodeMap;
        this.observedRootNodeMap = observedRootNodeMap;
    }

    @Override
    public void addCustomAllowedMasks(String ssrfMatcherEnumName, String ... matcherMasks) {
        StringMatcher stringMatcher;
        SSRFMatcherEnum ssrfMatcherEnum;
        if (ssrfMatcherEnumName != null && matcherMasks != null && matcherMasks.length > 0 && (ssrfMatcherEnum = SSRFMatcherEnum.fromValue((String)ssrfMatcherEnumName)) != null && (stringMatcher = this.rootNodeMap.get(ssrfMatcherEnum)) instanceof DelegateStringMatcher) {
            for (StringMatcher matcher : ((DelegateStringMatcher)stringMatcher).listDelegatedMatchers()) {
                this.addCustomAllowedSubnetMasksForSetBasedStringMatcher(matcher, ssrfMatcherEnum, matcherMasks);
            }
        }
    }

    private void addCustomAllowedSubnetMasksForSetBasedStringMatcher(StringMatcher stringMatcher, SSRFMatcherEnum ssrfMatcherEnum, String ... subnetMasks) {
        if (stringMatcher instanceof SetBasedStringMatcher) {
            SetBasedStringMatcher setBasedStringMatcher = (SetBasedStringMatcher)stringMatcher;
            setBasedStringMatcher.addItems(SSRFMatcherParamsFormatters.format(ssrfMatcherEnum, Arrays.asList(subnetMasks)));
        }
    }

    @Override
    public void removeCustomAllowedMasks(String ssrfMatcherEnumName, String ... matcherMasks) {
        StringMatcher stringMatcher;
        SSRFMatcherEnum ssrfMatcherEnum;
        if (ssrfMatcherEnumName != null && matcherMasks != null && matcherMasks.length > 0 && (ssrfMatcherEnum = SSRFMatcherEnum.fromValue((String)ssrfMatcherEnumName)) != null && (stringMatcher = this.rootNodeMap.get(ssrfMatcherEnum)) instanceof DelegateStringMatcher) {
            for (StringMatcher matcher : ((DelegateStringMatcher)stringMatcher).listDelegatedMatchers()) {
                this.removeCustomAllowedSubnetMasksForSetBasedStringMatcher(matcher, ssrfMatcherEnum, matcherMasks);
            }
        }
    }

    private void removeCustomAllowedSubnetMasksForSetBasedStringMatcher(StringMatcher stringMatcher, SSRFMatcherEnum ssrfMatcherEnum, String ... subnetMasks) {
        if (stringMatcher instanceof SetBasedStringMatcher) {
            SetBasedStringMatcher setBasedStringMatcher = (SetBasedStringMatcher)stringMatcher;
            setBasedStringMatcher.removeItems(SSRFMatcherParamsFormatters.format(ssrfMatcherEnum, Arrays.asList(subnetMasks)));
        }
    }

    @Override
    public Set<String> customAllowedMasks(String ssrfMatcherEnumName) {
        Iterator<StringMatcher> iterator;
        if (ssrfMatcherEnumName == null) {
            return Collections.emptySet();
        }
        SSRFMatcherEnum ssrfMatcherEnum = SSRFMatcherEnum.fromValue((String)ssrfMatcherEnumName);
        if (ssrfMatcherEnum == null) {
            return Collections.emptySet();
        }
        StringMatcher stringMatcher = this.rootNodeMap.get(ssrfMatcherEnum);
        if (stringMatcher instanceof SetBasedStringMatcher) {
            return ((SetBasedStringMatcher)stringMatcher).items();
        }
        if (stringMatcher instanceof DelegateStringMatcher && (iterator = ((DelegateStringMatcher)stringMatcher).listDelegatedMatchers().iterator()).hasNext()) {
            StringMatcher matcher = iterator.next();
            HashSet<String> result = new HashSet<String>();
            if (matcher instanceof SetBasedStringMatcher) {
                result.addAll(((SetBasedStringMatcher)matcher).items());
            }
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public boolean matches(String text, String ssrfMatcherEnumName) {
        return this.matches(text, ssrfMatcherEnumName, this.rootNodeMap);
    }

    @Override
    public boolean observedMatches(String text, String ssrfMatcherEnumName) {
        if (this.observedRootNodeMap == null || this.observedRootNodeMap.isEmpty()) {
            return false;
        }
        return this.matches(text, ssrfMatcherEnumName, this.observedRootNodeMap);
    }

    public boolean matches(String text, String ssrfMatcherEnumName, Map<SSRFMatcherEnum, StringMatcher> matcherEnumStringMatcherMap) {
        SSRFMatcherEnum ssrfMatcherEnum = SSRFMatcherEnum.fromValue((String)ssrfMatcherEnumName);
        StringMatcher matcher = matcherEnumStringMatcherMap.get(ssrfMatcherEnum);
        if (matcher == null) {
            return false;
        }
        return matcher.matches(text);
    }
}

