/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.ssrf.loader.resolver;

import com.alibaba.security.resource.ssrf.loader.resolver.AbstractSyncSsrfResolver;
import com.alibaba.security.resource.ssrf.loader.resolver.SsrfResolver;
import java.util.Arrays;
import java.util.List;

public class CompositeSsrfResolver
extends AbstractSyncSsrfResolver {
    private List<SsrfResolver> resolvers;
    private static final Class<AbstractSyncSsrfResolver> ABSTRACT_SYNC_SSRF_RESOLVER_CLASS = AbstractSyncSsrfResolver.class;

    public CompositeSsrfResolver(SsrfResolver ... resolvers) {
        this.resolvers = Arrays.asList(resolvers);
    }

    @Override
    void resolve() {
        for (SsrfResolver resolver : this.resolvers) {
            if (ABSTRACT_SYNC_SSRF_RESOLVER_CLASS.isInstance(resolver)) {
                ABSTRACT_SYNC_SSRF_RESOLVER_CLASS.cast(resolver).syncResolve();
            }
            this.domainList.addAll(resolver.resolveIntraDomainList());
            this.ipStringList.addAll(resolver.resolveIntraIpList());
            this.ipv6StringList.addAll(resolver.resolveIntraIpv6List());
            this.exDomainList.addAll(resolver.resolveExtraDomainList());
            this.exIpStringList.addAll(resolver.resolveExtraIpList());
            this.exIpv6StringList.addAll(resolver.resolveExtraIpv6List());
            this.trustedDomainList.addAll(resolver.resolveTrustedDomainList());
            this.trustedIpList.addAll(resolver.resolveTrustedIpList());
        }
    }

    @Override
    public void reset() {
        for (SsrfResolver resolver : this.resolvers) {
            resolver.reset();
        }
        super.reset();
    }
}

