/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.ssrf.loader.resolver;

import com.alibaba.security.resource.ssrf.config.xml.Domain;
import com.alibaba.security.resource.ssrf.config.xml.Ip;
import com.alibaba.security.resource.ssrf.config.xml.Ipv6;
import com.alibaba.security.resource.ssrf.loader.resolver.SsrfResolver;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSyncSsrfResolver
implements SsrfResolver {
    protected String resourcePath;
    protected List<Domain> domainList;
    protected List<Ip> ipStringList;
    protected List<Ipv6> ipv6StringList;
    protected List<Domain> exDomainList;
    protected List<Ip> exIpStringList;
    protected List<Ipv6> exIpv6StringList;
    protected List<Domain> trustedDomainList;
    protected List<Ip> trustedIpList;
    private volatile boolean resolved = false;

    public AbstractSyncSsrfResolver() {
        this(null);
    }

    public AbstractSyncSsrfResolver(String resourcePath) {
        this.resourcePath = resourcePath;
        this.domainList = new ArrayList<Domain>();
        this.ipStringList = new ArrayList<Ip>();
        this.ipv6StringList = new ArrayList<Ipv6>();
        this.exDomainList = new ArrayList<Domain>();
        this.exIpStringList = new ArrayList<Ip>();
        this.exIpv6StringList = new ArrayList<Ipv6>();
        this.trustedDomainList = new ArrayList<Domain>();
        this.trustedIpList = new ArrayList<Ip>();
    }

    abstract void resolve();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncResolve() {
        if (!this.resolved) {
            AbstractSyncSsrfResolver abstractSyncSsrfResolver = this;
            synchronized (abstractSyncSsrfResolver) {
                if (!this.resolved) {
                    this.clearAll();
                    this.resolve();
                    this.resolved = true;
                }
            }
        }
    }

    protected void clearAll() {
        this.domainList.clear();
        this.ipStringList.clear();
        this.ipv6StringList.clear();
        this.exDomainList.clear();
        this.exIpStringList.clear();
        this.exIpv6StringList.clear();
    }

    @Override
    public List<Domain> resolveIntraDomainList() {
        this.syncResolve();
        return this.domainList;
    }

    @Override
    public List<Ip> resolveIntraIpList() {
        this.syncResolve();
        return this.ipStringList;
    }

    @Override
    public List<Ipv6> resolveIntraIpv6List() {
        this.syncResolve();
        return this.ipv6StringList;
    }

    @Override
    public List<Domain> resolveExtraDomainList() {
        this.syncResolve();
        return this.exDomainList;
    }

    @Override
    public List<Ip> resolveExtraIpList() {
        this.syncResolve();
        return this.exIpStringList;
    }

    @Override
    public List<Ipv6> resolveExtraIpv6List() {
        this.syncResolve();
        return this.exIpv6StringList;
    }

    @Override
    public List<Domain> resolveTrustedDomainList() {
        this.syncResolve();
        return this.trustedDomainList;
    }

    @Override
    public List<Ip> resolveTrustedIpList() {
        this.syncResolve();
        return this.trustedIpList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AbstractSyncSsrfResolver abstractSyncSsrfResolver = this;
        synchronized (abstractSyncSsrfResolver) {
            this.resolved = false;
        }
    }
}

