/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.ssrf.loader.formatter;

import com.alibaba.security.resource.ResourceParseException;
import com.alibaba.security.resource.ssrf.loader.formatter.StringListFormatter;
import com.alibaba.security.url.model.SubnetMask;
import com.alibaba.security.util.AssertUtil;
import com.alibaba.security.util.IpAddressUtil;
import java.util.ArrayList;
import java.util.List;

public class Ips2SubnetMasksStringListFormatter
implements StringListFormatter<SubnetMask> {
    @Override
    public List<String> format(List<SubnetMask> ips) {
        ArrayList<String> result = new ArrayList<String>();
        for (SubnetMask subnetMask : AssertUtil.notNull(ips, "ips should not be null.")) {
            String ipAddressBinaryArray = IpAddressUtil.convertIpv4ToString(subnetMask.getAddress());
            if (ipAddressBinaryArray == null) {
                throw new ResourceParseException("Failed to parse " + subnetMask);
            }
            ipAddressBinaryArray = ipAddressBinaryArray.substring(0, subnetMask.getMask());
            if (subnetMask.getMask() == 32) {
                result.add(ipAddressBinaryArray);
                continue;
            }
            result.add(ipAddressBinaryArray + '*');
        }
        return result;
    }
}

