/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.ssrf.loader;

import com.alibaba.security.config.ConfigLoader;
import com.alibaba.security.config.SecurityConfig;
import com.alibaba.security.resource.ssrf.config.xml.Domain;
import com.alibaba.security.resource.ssrf.config.xml.Ip;
import com.alibaba.security.resource.ssrf.config.xml.Ipv6;
import com.alibaba.security.resource.ssrf.loader.AbstractSsrfMatcherLoader;
import com.alibaba.security.resource.ssrf.loader.resolver.CompositeSsrfResolver;
import com.alibaba.security.resource.ssrf.loader.resolver.SsrfJsonConfigResolver;
import com.alibaba.security.resource.ssrf.loader.resolver.SsrfXmlConfigResolver;
import com.alibaba.security.resource.ssrf.matcher.SsrfMatchable;
import com.alibaba.security.resource.ssrf.matcher.SsrfMatcher;
import com.alibaba.security.url.model.SSRFMatcherEnum;
import com.alibaba.security.url.ssrf.SSRFCheckerImpl;
import com.alibaba.security.util.ResourceUtil;
import com.alibaba.security.util.matcher.StringMatcher;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class SsrfMatcherLoader
extends AbstractSsrfMatcherLoader {
    protected static final Logger logger = Logger.getLogger(SsrfMatcherLoader.class.getName());
    private static final SecurityConfig SECURITY_CONFIG = ConfigLoader.loadSecurityConfig();
    private CompositeSsrfResolver compositeSsrfResolver;
    private CompositeSsrfResolver observedCompositeSsrfResolver;

    public SsrfMatcherLoader() {
        SsrfXmlConfigResolver defaultConfigResolver = new SsrfXmlConfigResolver("/com/alibaba/security/url/default-def-ssrf-host.xml");
        InputStream historyPath = ResourceUtil.getResourceInputSteam("/com/alibaba/security/url/custom-def-ssrf-host.xml", SSRFCheckerImpl.class);
        SsrfXmlConfigResolver customConfigResolver = historyPath != null ? new SsrfXmlConfigResolver("/com/alibaba/security/url/custom-def-ssrf-host.xml") : new SsrfXmlConfigResolver("/security/custom-def-ssrf-host.xml");
        if (SECURITY_CONFIG.isJsonResourcesLoadingEnable()) {
            SsrfJsonConfigResolver jsonConfigResolver = new SsrfJsonConfigResolver(SECURITY_CONFIG.getSsrfLocation(), SECURITY_CONFIG.getSsrfConfPath(), SECURITY_CONFIG.isSsrfAbsolutePath(), false);
            this.compositeSsrfResolver = new CompositeSsrfResolver(defaultConfigResolver, customConfigResolver, jsonConfigResolver);
            SsrfJsonConfigResolver observedJsonConfigResolver = new SsrfJsonConfigResolver(SECURITY_CONFIG.getSsrfLocation(), SECURITY_CONFIG.getSsrfConfPath(), SECURITY_CONFIG.isSsrfAbsolutePath(), true);
            this.observedCompositeSsrfResolver = new CompositeSsrfResolver(observedJsonConfigResolver);
        } else {
            this.compositeSsrfResolver = new CompositeSsrfResolver(defaultConfigResolver, customConfigResolver);
        }
    }

    public SsrfMatchable load(Path path) {
        Map<SSRFMatcherEnum, StringMatcher> rootNodeMap = this.resolveAndBuildRootNodeMap(this.compositeSsrfResolver);
        Map<SSRFMatcherEnum, StringMatcher> observedRootNodeMap = this.resolveAndBuildRootNodeMap(this.observedCompositeSsrfResolver);
        return new SsrfMatcher(rootNodeMap, observedRootNodeMap);
    }

    private Map<SSRFMatcherEnum, StringMatcher> resolveAndBuildRootNodeMap(CompositeSsrfResolver resolver) {
        if (resolver == null) {
            return Collections.emptyMap();
        }
        EnumMap<SSRFMatcherEnum, StringMatcher> rootNodeMap = new EnumMap<SSRFMatcherEnum, StringMatcher>(SSRFMatcherEnum.class);
        resolver.reset();
        List<Domain> domainList = resolver.resolveIntraDomainList();
        List<Ip> ipStringList = resolver.resolveIntraIpList();
        List<Ipv6> ipv6StringList = resolver.resolveIntraIpv6List();
        List<Domain> exDomainList = resolver.resolveExtraDomainList();
        List<Ip> exIpStringList = resolver.resolveExtraIpList();
        List<Ipv6> exIpv6StringList = resolver.resolveExtraIpv6List();
        List<Domain> trustedDomainList = resolver.resolveTrustedDomainList();
        List<Ip> trustedIpList = resolver.resolveTrustedIpList();
        this.buildDomainsMatcher(domainList, SSRFMatcherEnum.INTRANET_DOMAIN, rootNodeMap);
        this.buildIpsTrie(ipStringList, SSRFMatcherEnum.INTRANET_IP, rootNodeMap);
        this.buildIpv6sTrie(ipv6StringList, SSRFMatcherEnum.INTRANET_IPV6, rootNodeMap);
        this.buildDomainsMatcher(exDomainList, SSRFMatcherEnum.EXCLUDED_DOMAIN, rootNodeMap);
        this.buildIpsTrie(exIpStringList, SSRFMatcherEnum.EXCLUDED_IP, rootNodeMap);
        this.buildIpv6sTrie(exIpv6StringList, SSRFMatcherEnum.EXCLUDED_IPV6, rootNodeMap);
        this.buildDomainsMatcher(trustedDomainList, SSRFMatcherEnum.TRUSTED_DOMAIN, rootNodeMap);
        this.buildIpsTrie(trustedIpList, SSRFMatcherEnum.TRUSTED_IP, rootNodeMap);
        return rootNodeMap;
    }
}

