/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.safeurl.loader.resolver;

import com.alibaba.security.resource.safeurl.config.xml.Domains;
import com.alibaba.security.resource.safeurl.loader.parser.SafeUrlXmlParser;
import com.alibaba.security.resource.safeurl.loader.resolver.AbstractSyncSafeUrlOnceResolver;
import com.alibaba.security.url.safeurl.ParseWhiteListException;
import com.alibaba.security.util.IOUtils;
import com.alibaba.security.util.ResourceUtil;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SafeUrlXmlConfigResolver
extends AbstractSyncSafeUrlOnceResolver {
    private static final Logger logger = Logger.getLogger(SafeUrlXmlConfigResolver.class.getName());
    private boolean productionMode;

    public SafeUrlXmlConfigResolver(boolean productionMode) {
        this.productionMode = productionMode;
    }

    @Override
    void resolve() {
        try {
            String domainUrl = this.productionMode ? "/com/alibaba/security/url/default-safe-domain.xml" : "/com/alibaba/security/url/daily-default-safe-domain.xml";
            this.parseAndSetDomains(domainUrl);
            this.parseAndSetDomains("/com/alibaba/security/url/custom-safe-domain.xml");
        }
        catch (ParseWhiteListException ex) {
            if (ex.getMessage() != null) {
                logger.log(Level.WARNING, ex.getMessage());
            } else {
                logger.log(Level.WARNING, "Fail to load safe url list.");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Fail to load safe url list.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAndSetDomains(String domainUrl) throws ParseWhiteListException {
        InputStream inputStream = ResourceUtil.getResourceInputSteam(domainUrl, this.getClass());
        if (inputStream != null) {
            try {
                Domains domains = new SafeUrlXmlParser(inputStream).parse();
                this.mergeSafeDomainsList(domains.getSafedomains());
                this.mergeBlockDomainsList(domains.getBlockdomains());
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        } else {
            logger.info("domainUrl: " + domainUrl + " is not exist");
        }
    }
}

