/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.net;

import com.alibaba.security.net.NetHooksEvent;
import com.alibaba.security.net.NetHooksEventListener;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import sun.net.NetHooks;

public class SecurityNetHooksProvider
extends NetHooks.Provider {
    private NetHooks.Provider delegate;
    private static final List<NetHooksEventListener> registeredListener = new CopyOnWriteArrayList<NetHooksEventListener>();

    public SecurityNetHooksProvider(NetHooks.Provider provider) {
        this.delegate = provider;
    }

    public static void registerListener(NetHooksEventListener listener) {
        registeredListener.add(listener);
    }

    static void setProvider(Field field) throws Exception {
        if (field != null) {
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(field, new SecurityNetHooksProvider((NetHooks.Provider)field.get(NetHooks.class)));
        }
    }

    @Override
    public void implBeforeTcpBind(FileDescriptor fileDescriptor, InetAddress inetAddress, int i) throws IOException {
        this.delegate.implBeforeTcpBind(fileDescriptor, inetAddress, i);
    }

    @Override
    public void implBeforeTcpConnect(FileDescriptor fileDescriptor, InetAddress inetAddress, int i) throws IOException {
        for (NetHooksEventListener netHooksEventListener : registeredListener) {
            netHooksEventListener.handleBeforeTcpConnect(new NetHooksEvent(inetAddress));
        }
        this.delegate.implBeforeTcpConnect(fileDescriptor, inetAddress, i);
    }

    static {
        try {
            SecurityNetHooksProvider.setProvider(NetHooks.class.getDeclaredField("provider"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

