/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.mask.model.guest;

import com.alibaba.security.mask.DataType;
import com.alibaba.security.mask.model.guest.AbstractGuestMaskModel;
import com.alibaba.security.util.SensitiveDataUtil;

public class EmailWebGuestMaskModel
extends AbstractGuestMaskModel {
    @Override
    public DataType getDataType() {
        return DataType.Email_Web;
    }

    @Override
    public String doMask(String input) {
        if (input.indexOf(64) != -1) {
            String[] split = input.split("@");
            StringBuilder sb = new StringBuilder();
            if (split[0].length() <= 2) {
                sb.append("**");
            } else {
                sb.append(SensitiveDataUtil.customizeIntraMark(split[0], 3, 0, 3));
            }
            sb.append('@').append(split[1]);
            return sb.toString();
        }
        return null;
    }

    @Override
    protected boolean isValidationSupported() {
        return true;
    }

    @Override
    public boolean validate(String input) {
        return SensitiveDataUtil.isEmailAddress(input);
    }
}

