/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.mask;

import com.alibaba.security.mask.DataMaskConfiguration;
import com.alibaba.security.mask.DataMaskingTool;
import com.alibaba.security.mask.DataType;
import com.alibaba.security.mask.MaskModel;
import com.alibaba.security.mask.Scenario;
import com.alibaba.security.mask.exception.CompleteTextNotAllowedException;
import com.alibaba.security.mask.exception.ValidationNotSupportedException;
import com.alibaba.security.mask.model.auth.AddressAuthMaskModel;
import com.alibaba.security.mask.model.auth.CnMobilePhoneWebAuthMaskModel;
import com.alibaba.security.mask.model.auth.DebitCardAuthMaskModel;
import com.alibaba.security.mask.model.auth.EmailAuthMaskModel;
import com.alibaba.security.mask.model.auth.EmailSMSAuthMaskModel;
import com.alibaba.security.mask.model.auth.EmailWebAuthMaskModel;
import com.alibaba.security.mask.model.auth.IDCardNoAuthMaskModel;
import com.alibaba.security.mask.model.auth.NameAuthMaskModel;
import com.alibaba.security.mask.model.auth.NickNameAuthMaskModel;
import com.alibaba.security.mask.model.auth.PhoneAuthMaskModel;
import com.alibaba.security.mask.model.auth.PostcodeAuthMaskModel;
import com.alibaba.security.mask.model.guest.AddressGuestMaskModel;
import com.alibaba.security.mask.model.guest.CnMobilePhoneWebGuestMaskModel;
import com.alibaba.security.mask.model.guest.DebitCardGuestMaskModel;
import com.alibaba.security.mask.model.guest.EmailGuestMaskModel;
import com.alibaba.security.mask.model.guest.EmailSMSGuestMaskModel;
import com.alibaba.security.mask.model.guest.EmailWebGuestMaskModel;
import com.alibaba.security.mask.model.guest.IDCardNoGuestMaskModel;
import com.alibaba.security.mask.model.guest.NameGuestMaskModel;
import com.alibaba.security.mask.model.guest.NickNameGuestMaskModel;
import com.alibaba.security.mask.model.guest.PhoneGuestMaskModel;
import com.alibaba.security.mask.model.guest.PostcodeGuestMaskModel;
import com.alibaba.security.mask.model.login.AddressLoginMaskModel;
import com.alibaba.security.mask.model.login.CnMobilePhoneWebLoginMaskModel;
import com.alibaba.security.mask.model.login.DebitCardLoginMaskModel;
import com.alibaba.security.mask.model.login.EmailLoginMaskModel;
import com.alibaba.security.mask.model.login.EmailSMSLoginMaskModel;
import com.alibaba.security.mask.model.login.EmailWebLoginMaskModel;
import com.alibaba.security.mask.model.login.IDCardNoLoginMaskModel;
import com.alibaba.security.mask.model.login.NameLoginMaskModel;
import com.alibaba.security.mask.model.login.NickNameLoginMaskModel;
import com.alibaba.security.mask.model.login.PhoneLoginMaskModel;
import com.alibaba.security.mask.model.login.PostcodeLoginMaskModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DataMaskingToolImpl
implements DataMaskingTool {
    private static Map<Integer, MaskModel> modelMap;
    private static Map<Integer, MaskModel> theModelMap;

    private static void registerModel(MaskModel maskModel) {
        int index = DataMaskingToolImpl.getIndex(maskModel.getDataType(), maskModel.getScenario());
        theModelMap.put(index, maskModel);
    }

    private MaskModel getModel(DataType dataType, Scenario scenario) {
        return modelMap.get(DataMaskingToolImpl.getIndex(dataType, scenario));
    }

    private static int getIndex(DataType dataType, Scenario scenario) {
        return dataType.getIndex() * 10 + scenario.getIndex();
    }

    public String mask(DataType dataType, Scenario scenario, String data) {
        if (!DataMaskingToolImpl.isValid(dataType, scenario, data)) {
            return null;
        }
        MaskModel model = this.getModel(dataType, scenario);
        if (model != null) {
            return model.mask(data);
        }
        return null;
    }

    public String mask(DataType dataType, Scenario scenario, String data, boolean full) throws CompleteTextNotAllowedException {
        if (!DataMaskingToolImpl.isValid(dataType, scenario, data)) {
            return null;
        }
        MaskModel model = this.getModel(dataType, scenario);
        if (model != null) {
            return model.mask(data, full);
        }
        return null;
    }

    public String mask(String data, DataMaskConfiguration configuration) throws CompleteTextNotAllowedException, ValidationNotSupportedException {
        if (!DataMaskingToolImpl.isValid(configuration, data)) {
            return null;
        }
        if (!DataMaskingToolImpl.isValid(configuration.getDataType(), configuration.getScenario())) {
            return null;
        }
        MaskModel model = this.getModel(configuration.getDataType(), configuration.getScenario());
        if (model != null) {
            return model.mask(data, configuration.canFull());
        }
        return null;
    }

    private static boolean isValid(Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            return false;
        }
        return true;
    }

    static {
        theModelMap = new HashMap<Integer, MaskModel>();
        DataMaskingToolImpl.registerModel(new NickNameGuestMaskModel());
        DataMaskingToolImpl.registerModel(new NickNameLoginMaskModel());
        DataMaskingToolImpl.registerModel(new NickNameAuthMaskModel());
        DataMaskingToolImpl.registerModel(new NameGuestMaskModel());
        DataMaskingToolImpl.registerModel(new NameLoginMaskModel());
        DataMaskingToolImpl.registerModel(new NameAuthMaskModel());
        DataMaskingToolImpl.registerModel(new PhoneGuestMaskModel());
        DataMaskingToolImpl.registerModel(new PhoneLoginMaskModel());
        DataMaskingToolImpl.registerModel(new PhoneAuthMaskModel());
        DataMaskingToolImpl.registerModel(new CnMobilePhoneWebGuestMaskModel());
        DataMaskingToolImpl.registerModel(new CnMobilePhoneWebLoginMaskModel());
        DataMaskingToolImpl.registerModel(new CnMobilePhoneWebAuthMaskModel());
        DataMaskingToolImpl.registerModel(new AddressGuestMaskModel());
        DataMaskingToolImpl.registerModel(new AddressLoginMaskModel());
        DataMaskingToolImpl.registerModel(new AddressAuthMaskModel());
        DataMaskingToolImpl.registerModel(new EmailSMSGuestMaskModel());
        DataMaskingToolImpl.registerModel(new EmailSMSLoginMaskModel());
        DataMaskingToolImpl.registerModel(new EmailSMSAuthMaskModel());
        DataMaskingToolImpl.registerModel(new DebitCardGuestMaskModel());
        DataMaskingToolImpl.registerModel(new DebitCardLoginMaskModel());
        DataMaskingToolImpl.registerModel(new DebitCardAuthMaskModel());
        DataMaskingToolImpl.registerModel(new IDCardNoGuestMaskModel());
        DataMaskingToolImpl.registerModel(new IDCardNoLoginMaskModel());
        DataMaskingToolImpl.registerModel(new IDCardNoAuthMaskModel());
        DataMaskingToolImpl.registerModel(new EmailWebGuestMaskModel());
        DataMaskingToolImpl.registerModel(new EmailWebLoginMaskModel());
        DataMaskingToolImpl.registerModel(new EmailWebAuthMaskModel());
        DataMaskingToolImpl.registerModel(new PostcodeGuestMaskModel());
        DataMaskingToolImpl.registerModel(new PostcodeLoginMaskModel());
        DataMaskingToolImpl.registerModel(new PostcodeAuthMaskModel());
        DataMaskingToolImpl.registerModel(new EmailGuestMaskModel());
        DataMaskingToolImpl.registerModel(new EmailLoginMaskModel());
        DataMaskingToolImpl.registerModel(new EmailAuthMaskModel());
        modelMap = Collections.unmodifiableMap(theModelMap);
        theModelMap = null;
    }
}

