/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.di.sqoop.converter;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiDatasourceMappingConfig;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptStep;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptStepParameter;
import com.aliyun.migration.workflow.migration.common.transform.di.module.DiStepTypeHandler;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBC2PolardbConverter
implements DiStepTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(JDBC2PolardbConverter.class);

    @Override
    public DiScriptStep convertToDwSourceStep(DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping config, JSONObject jobParams) {
        DiScriptStep sourceStep = new DiScriptStep();
        sourceStep.setName("Reader");
        sourceStep.setStepType("polardb");
        sourceStep.setCategory("reader");
        DiScriptStepParameter stepParameter = new DiScriptStepParameter();
        stepParameter.setDatasource(config.getTgtName());
        if (jobParams.containsKey("table")) {
            stepParameter.setTable(jobParams.getString("table"));
        }
        if (jobParams.containsKey("where")) {
            stepParameter.setWhere(jobParams.getString("where"));
        }
        if (jobParams.containsKey("columns")) {
            stepParameter.setColumn(Arrays.stream(jobParams.getString("columns").split(",")).map(String::trim).collect(Collectors.toList()));
        } else {
            stepParameter.setColumn(List.of("*"));
        }
        if (jobParams.containsKey("split-by")) {
            stepParameter.setSplitPk(jobParams.getString("split-by"));
        }
        if (jobParams.containsKey("query")) {
            stepParameter.setPreSql(List.of(jobParams.getString("query")));
        }
        sourceStep.setParameter(stepParameter);
        return sourceStep;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping config, JSONObject jobParams) {
        DiScriptStep destStep = new DiScriptStep();
        destStep.setName("Writer");
        destStep.setStepType("polardb");
        destStep.setCategory("writer");
        DiScriptStepParameter stepParameter = new DiScriptStepParameter();
        stepParameter.setDatasource(config.getTgtName());
        if (jobParams.containsKey("table")) {
            stepParameter.setTable(jobParams.getString("table"));
        }
        if (jobParams.containsKey("update-mode") && jobParams.getString("update-mode").equals("allowinsert")) {
            stepParameter.setWriteMode("insert");
        } else {
            stepParameter.setWriteMode("update");
            if (jobParams.containsKey("update-key")) {
                stepParameter.setUpdateColumn(List.of(jobParams.getString("update-key")));
            }
        }
        if (jobParams.containsKey("columns")) {
            stepParameter.setColumn(Arrays.stream(jobParams.getString("columns").split(",")).map(String::trim).collect(Collectors.toList()));
        } else {
            stepParameter.setColumn(List.of("*"));
        }
        destStep.setParameter(stepParameter);
        return destStep;
    }
}

