/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.di.seatunnel;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.workflow.migration.common.transform.di.module.AbstractDIScriptConverter;
import com.aliyun.migration.workflow.migration.common.transform.di.seatunnel.SinkConnector2WriterConvertFactory;
import com.aliyun.migration.workflow.migration.common.transform.di.seatunnel.SourceConnector2ReaderConvertFactory;
import com.aliyun.migration.workflow.migration.common.transform.di.seatunnel.utils.SeatunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeatunnelScriptConverter
extends AbstractDIScriptConverter {
    private static final Logger log = LoggerFactory.getLogger(SeatunnelScriptConverter.class);

    public SeatunnelScriptConverter() {
        super(new SourceConnector2ReaderConvertFactory(), new SinkConnector2WriterConvertFactory());
    }

    @Override
    public JSONObject getRawScriptJson(String rawScript) {
        return SeatunnelUtils.getSeatunnelConfigJson(rawScript);
    }

    @Override
    public String getSourceDatasourceName(JSONObject rawScriptJson) {
        String sourceDatasourceName = this.getDatasourceName((JSONObject)rawScriptJson.getJSONArray("source").get(0));
        return sourceDatasourceName;
    }

    @Override
    public String getSinkDatasourceName(JSONObject rawScriptJson) {
        String sinkDatasourceName = this.getDatasourceName((JSONObject)rawScriptJson.getJSONArray("sink").get(0));
        return sinkDatasourceName;
    }

    private String getDatasourceName(JSONObject source) {
        String pluginName;
        switch (pluginName = source.getString("plugin_name")) {
            case "Hive": {
                return source.getString("table_name").split("\\.")[0];
            }
            case "jdbc": {
                return SeatunnelUtils.getHostFromUrl(source.getString("url")).get("dbName");
            }
            case "Doris": 
            case "Clickhouse": {
                return source.getString("database");
            }
        }
        if (source.containsKey("database")) {
            return source.getString("database");
        }
        if (source.containsKey("table_name") && source.getString("table_name").contains(".")) {
            return source.getString("table_name").split("\\.")[0];
        }
        if (source.containsKey("url")) {
            return SeatunnelUtils.getHostFromUrl(source.getString("url")).get("dbName");
        }
        return null;
    }
}

