/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.di.datax;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.workflow.migration.common.transform.di.datax.ReaderConvertFactory;
import com.aliyun.migration.workflow.migration.common.transform.di.datax.WriterConvertFactory;
import com.aliyun.migration.workflow.migration.common.transform.di.datax.utils.DataxUtils;
import com.aliyun.migration.workflow.migration.common.transform.di.module.AbstractDIScriptConverter;

public class DataxScriptConverter
extends AbstractDIScriptConverter {
    public DataxScriptConverter() {
        super(new ReaderConvertFactory(), new WriterConvertFactory());
    }

    @Override
    public JSONObject getRawScriptJson(String rawScript) {
        try {
            return JSONObject.parseObject((String)rawScript);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getSourceDatasourceName(JSONObject rawScriptJson) {
        String readerType;
        JSONObject readerJson = rawScriptJson.getJSONObject("job").getJSONObject("content").getJSONObject("reader");
        switch (readerType = readerJson.getString("name")) {
            case "mysqlreader": 
            case "oraclereader": 
            case "postgresqlreader": 
            case "sqlserverreader": {
                return DataxUtils.getDatabaseFromUrl(readerJson.getJSONObject("parameter").getJSONArray("connection").getJSONObject(0).getJSONArray("jdbcUrl").getString(0));
            }
            case "hdfsreader": {
                return readerJson.getJSONObject("parameter").getString("path");
            }
            case "ossreader": {
                return readerJson.getJSONObject("parameter").getString("endpoint") + "/" + readerJson.getJSONObject("parameter").getString("bucket") + "/" + readerJson.getJSONObject("parameter").getString("object");
            }
            case "mongodbreader": {
                return readerJson.getJSONObject("parameter").getString("dbName");
            }
            case "odpsreader": {
                return readerJson.getJSONObject("parameter").getString("project");
            }
        }
        return null;
    }

    @Override
    public String getSinkDatasourceName(JSONObject rawScriptJson) {
        String readerType;
        JSONObject readerJson = rawScriptJson.getJSONObject("job").getJSONObject("content").getJSONObject("writer");
        switch (readerType = readerJson.getString("name")) {
            case "mysqlwriter": 
            case "oraclewriter": 
            case "postgresqlwriter": 
            case "sqlserverwriter": {
                return DataxUtils.getDatabaseFromUrl(readerJson.getJSONObject("parameter").getJSONArray("connection").getJSONObject(0).getJSONArray("jdbcUrl").getString(0));
            }
            case "hdfswriter": {
                return readerJson.getJSONObject("parameter").getString("path");
            }
            case "osswriter": {
                return readerJson.getJSONObject("parameter").getString("endpoint") + "/" + readerJson.getJSONObject("parameter").getString("bucket") + "/" + readerJson.getJSONObject("parameter").getString("object");
            }
            case "mongodbwriter": {
                return readerJson.getJSONObject("parameter").getString("dbName");
            }
            case "odpswriter": {
                return readerJson.getJSONObject("parameter").getString("project");
            }
        }
        return "";
    }
}

