/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.serving;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.serving.BuildLogsRequest;
import com.databricks.sdk.service.serving.BuildLogsResponse;
import com.databricks.sdk.service.serving.CreateServingEndpoint;
import com.databricks.sdk.service.serving.DeleteResponse;
import com.databricks.sdk.service.serving.DeleteServingEndpointRequest;
import com.databricks.sdk.service.serving.EndpointCoreConfigInput;
import com.databricks.sdk.service.serving.EndpointTags;
import com.databricks.sdk.service.serving.ExportMetricsRequest;
import com.databricks.sdk.service.serving.ExportMetricsResponse;
import com.databricks.sdk.service.serving.ExternalFunctionRequest;
import com.databricks.sdk.service.serving.GetOpenApiRequest;
import com.databricks.sdk.service.serving.GetOpenApiResponse;
import com.databricks.sdk.service.serving.GetServingEndpointPermissionLevelsRequest;
import com.databricks.sdk.service.serving.GetServingEndpointPermissionLevelsResponse;
import com.databricks.sdk.service.serving.GetServingEndpointPermissionsRequest;
import com.databricks.sdk.service.serving.GetServingEndpointRequest;
import com.databricks.sdk.service.serving.HttpRequestResponse;
import com.databricks.sdk.service.serving.ListEndpointsResponse;
import com.databricks.sdk.service.serving.LogsRequest;
import com.databricks.sdk.service.serving.PatchServingEndpointTags;
import com.databricks.sdk.service.serving.PutAiGatewayRequest;
import com.databricks.sdk.service.serving.PutAiGatewayResponse;
import com.databricks.sdk.service.serving.PutRequest;
import com.databricks.sdk.service.serving.PutResponse;
import com.databricks.sdk.service.serving.QueryEndpointInput;
import com.databricks.sdk.service.serving.QueryEndpointResponse;
import com.databricks.sdk.service.serving.ServerLogsResponse;
import com.databricks.sdk.service.serving.ServingEndpointDetailed;
import com.databricks.sdk.service.serving.ServingEndpointPermissions;
import com.databricks.sdk.service.serving.ServingEndpointPermissionsRequest;
import com.databricks.sdk.service.serving.ServingEndpointsService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class ServingEndpointsImpl
implements ServingEndpointsService {
    private final ApiClient apiClient;

    public ServingEndpointsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public BuildLogsResponse buildLogs(BuildLogsRequest request) {
        String path = String.format("/api/2.0/serving-endpoints/%s/served-models/%s/build-logs", request.getName(), request.getServedModelName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, BuildLogsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ServingEndpointDetailed create(CreateServingEndpoint request) {
        String path = "/api/2.0/serving-endpoints";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ServingEndpointDetailed.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteServingEndpointRequest request) {
        String path = String.format("/api/2.0/serving-endpoints/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ExportMetricsResponse exportMetrics(ExportMetricsRequest request) {
        String path = String.format("/api/2.0/serving-endpoints/%s/metrics", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "text/plain");
            return this.apiClient.execute(req, ExportMetricsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ServingEndpointDetailed get(GetServingEndpointRequest request) {
        String path = String.format("/api/2.0/serving-endpoints/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ServingEndpointDetailed.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetOpenApiResponse getOpenApi(GetOpenApiRequest request) {
        String path = String.format("/api/2.0/serving-endpoints/%s/openapi", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "text/plain");
            return this.apiClient.execute(req, GetOpenApiResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetServingEndpointPermissionLevelsResponse getPermissionLevels(GetServingEndpointPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/serving-endpoints/%s/permissionLevels", request.getServingEndpointId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetServingEndpointPermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ServingEndpointPermissions getPermissions(GetServingEndpointPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/serving-endpoints/%s", request.getServingEndpointId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ServingEndpointPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public HttpRequestResponse httpRequest(ExternalFunctionRequest request) {
        String path = "/api/2.0/external-function";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "text/plain");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, HttpRequestResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListEndpointsResponse list() {
        String path = "/api/2.0/serving-endpoints";
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListEndpointsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ServerLogsResponse logs(LogsRequest request) {
        String path = String.format("/api/2.0/serving-endpoints/%s/served-models/%s/logs", request.getName(), request.getServedModelName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ServerLogsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public EndpointTags patch(PatchServingEndpointTags request) {
        String path = String.format("/api/2.0/serving-endpoints/%s/tags", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, EndpointTags.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PutResponse put(PutRequest request) {
        String path = String.format("/api/2.0/serving-endpoints/%s/rate-limits", request.getName());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, PutResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PutAiGatewayResponse putAiGateway(PutAiGatewayRequest request) {
        String path = String.format("/api/2.0/serving-endpoints/%s/ai-gateway", request.getName());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, PutAiGatewayResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public QueryEndpointResponse query(QueryEndpointInput request) {
        String path = String.format("/serving-endpoints/%s/invocations", request.getName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, QueryEndpointResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ServingEndpointPermissions setPermissions(ServingEndpointPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/serving-endpoints/%s", request.getServingEndpointId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ServingEndpointPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ServingEndpointDetailed updateConfig(EndpointCoreConfigInput request) {
        String path = String.format("/api/2.0/serving-endpoints/%s/config", request.getName());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ServingEndpointDetailed.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ServingEndpointPermissions updatePermissions(ServingEndpointPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/serving-endpoints/%s", request.getServingEndpointId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ServingEndpointPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

