/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.provisioning;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.provisioning.CreateNetworkRequest;
import com.databricks.sdk.service.provisioning.DeleteNetworkRequest;
import com.databricks.sdk.service.provisioning.DeleteResponse;
import com.databricks.sdk.service.provisioning.GetNetworkRequest;
import com.databricks.sdk.service.provisioning.Network;
import com.databricks.sdk.service.provisioning.NetworksService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;
import java.util.Collection;

@Generated
class NetworksImpl
implements NetworksService {
    private final ApiClient apiClient;

    public NetworksImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Network create(CreateNetworkRequest request) {
        String path = String.format("/api/2.0/accounts/%s/networks", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Network.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteNetworkRequest request) {
        String path = String.format("/api/2.0/accounts/%s/networks/%s", this.apiClient.configuredAccountID(), request.getNetworkId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Network get(GetNetworkRequest request) {
        String path = String.format("/api/2.0/accounts/%s/networks/%s", this.apiClient.configuredAccountID(), request.getNetworkId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Network.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<Network> list() {
        String path = String.format("/api/2.0/accounts/%s/networks", this.apiClient.configuredAccountID());
        Request req = new Request("GET", path);
        req.withHeader("Accept", "application/json");
        return this.apiClient.getCollection(req, Network.class);
    }
}

