/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.dbr.reader.module;

import com.alibaba.cola.dto.Response;
import com.alibaba.cola.dto.SingleResponse;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.dbr.reader.convert.DbrConverter;
import com.aliyun.migration.workflow.migration.common.AbstractReader;
import com.cronutils.utils.StringUtils;
import com.databricks.sdk.WorkspaceClient;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.service.jobs.BaseJob;
import com.databricks.sdk.service.jobs.ForEachTask;
import com.databricks.sdk.service.jobs.JobSettings;
import com.databricks.sdk.service.jobs.JobsAPI;
import com.databricks.sdk.service.jobs.ListJobsRequest;
import com.databricks.sdk.service.jobs.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class DbrReader
extends AbstractReader {
    private WorkspaceClient w;

    public Reader init(TaskContext taskContext) {
        this.setTaskContext(taskContext);
        this.optimalizeReader();
        Datasource readerDatasource = taskContext.getReaderDatasource();
        this.supplyDataSourceOperatorType(readerDatasource);
        DatabricksConfig cfg = new DatabricksConfig().setHost((String)readerDatasource.getProperties().get("endpoint")).setToken((String)readerDatasource.getProperties().get("token"));
        this.w = new WorkspaceClient(cfg);
        return this;
    }

    public Response preCheck(Datasource scheduleDataSource) {
        String accountId = this.w.apiClient().configuredAccountID();
        if (!StringUtils.isEmpty((CharSequence)accountId)) {
            return SingleResponse.buildSuccess();
        }
        return SingleResponse.buildFailure((String)BwmServiceErrorCode.DBR_SERVER_CALL_FAILED.getCode(), (String)"dbr.get.account.error");
    }

    public WorkflowProjectPackage read() throws Exception {
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        WorkflowProject workflowProject = new WorkflowProject();
        workflowProject.setName("dbr");
        workflowProject.setProjectId("dbr_" + this.w.apiClient().configuredAccountID());
        workflowProjectPackage.setWorkflowProject(workflowProject);
        ArrayList<Workflow> workflowList = new ArrayList<Workflow>();
        JobsAPI jobsAPI = this.w.jobs();
        ListJobsRequest listJobsRequest = new ListJobsRequest();
        listJobsRequest.setExpandTasks(Boolean.valueOf(true));
        listJobsRequest.setLimit(Long.valueOf(20L));
        Iterable list = jobsAPI.list(listJobsRequest);
        while (list.iterator().hasNext()) {
            BaseJob baseJob = (BaseJob)list.iterator().next();
            List<Task> forEachTasks = baseJob.getSettings().getTasks().stream().filter(x -> Objects.nonNull(x.getForEachTask())).toList();
            for (Task forEachTask : forEachTasks) {
                ForEachTask forEachSingleTask = forEachTask.getForEachTask();
                Task task = forEachSingleTask.getTask();
                BaseJob foreachJob = new BaseJob();
                foreachJob.setJobId(baseJob.getJobId());
                JobSettings jobSettings = new JobSettings();
                jobSettings.setTasks(List.of(task));
                jobSettings.setName(forEachTask.getTaskKey());
                foreachJob.setSettings(jobSettings);
                DbrConverter dbrConverter = new DbrConverter(this.w);
                Workflow convertWorkflow = dbrConverter.convert(foreachJob);
                convertWorkflow.setWorkflowId(convertWorkflow.getWorkflowId() + "_" + baseJob.getSettings().getName() + "_" + forEachTask.getTaskKey());
                convertWorkflow.setWorkflowName(convertWorkflow.getWorkflowName() + "_" + forEachTask.getTaskKey());
                List res = convertWorkflow.getWorkflowNodes();
                WorkflowNode workflowNode = (WorkflowNode)res.get(0);
                WorkflowNode startNode = new WorkflowNode();
                startNode.setNodeId(workflowNode.getNodeId() + "_start");
                startNode.setNodeName(workflowNode.getNodeName() + "_start");
                startNode.setNodeType(CodeProgramType.CONTROLLER_TRAVERSE_START.getName());
                WorkflowNode endNode = new WorkflowNode();
                endNode.setNodeId(workflowNode.getNodeId() + "_end");
                endNode.setNodeName(workflowNode.getNodeName() + "_end");
                endNode.setNodeType(CodeProgramType.CONTROLLER_TRAVERSE_END.getName());
                ArrayList<RelationPackage> nodeRelations = convertWorkflow.getNodeRelations();
                if (CollectionUtils.isEmpty((Collection)nodeRelations)) {
                    nodeRelations = new ArrayList<RelationPackage>();
                }
                nodeRelations.add(RelationPackage.builder().from(startNode.getNodeId()).to(workflowNode.getNodeId()).reType(RelationPackage.ReType.NODE).build());
                nodeRelations.add(RelationPackage.builder().from(workflowNode.getNodeId()).to(endNode.getNodeId()).reType(RelationPackage.ReType.NODE).build());
                res.add(startNode);
                res.add(endNode);
                convertWorkflow.setWorkflowNodes(res);
                convertWorkflow.setNodeRelations(nodeRelations);
                convertWorkflow.setProjectId(workflowProject.getProjectId());
                convertWorkflow.setProjectName(workflowProject.getName());
                workflowList.add(convertWorkflow);
            }
            DbrConverter dbrConverter = new DbrConverter(this.w);
            Workflow convertWorkflow = dbrConverter.convert(baseJob);
            convertWorkflow.setProjectId(workflowProject.getProjectId());
            convertWorkflow.setProjectName(workflowProject.getName());
            workflowList.add(convertWorkflow);
        }
        workflowProjectPackage.setWorkflowList(workflowList);
        this.taskContext.setWorkflowProjectPackage(workflowProjectPackage);
        return workflowProjectPackage;
    }
}

