/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.dbr.reader.convert;

import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.utils.Base64Tool;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.databricks.sdk.WorkspaceClient;
import com.databricks.sdk.service.jobs.BaseJob;
import com.databricks.sdk.service.jobs.CleanRoomsNotebookTask;
import com.databricks.sdk.service.jobs.ConditionTask;
import com.databricks.sdk.service.jobs.CronSchedule;
import com.databricks.sdk.service.jobs.DashboardTask;
import com.databricks.sdk.service.jobs.DbtTask;
import com.databricks.sdk.service.jobs.ForEachTask;
import com.databricks.sdk.service.jobs.GenAiComputeTask;
import com.databricks.sdk.service.jobs.JobSettings;
import com.databricks.sdk.service.jobs.NotebookTask;
import com.databricks.sdk.service.jobs.PauseStatus;
import com.databricks.sdk.service.jobs.PipelineTask;
import com.databricks.sdk.service.jobs.PowerBiTask;
import com.databricks.sdk.service.jobs.PythonWheelTask;
import com.databricks.sdk.service.jobs.RunJobTask;
import com.databricks.sdk.service.jobs.Source;
import com.databricks.sdk.service.jobs.SparkJarTask;
import com.databricks.sdk.service.jobs.SparkPythonTask;
import com.databricks.sdk.service.jobs.SparkSubmitTask;
import com.databricks.sdk.service.jobs.SqlTask;
import com.databricks.sdk.service.jobs.SqlTaskFile;
import com.databricks.sdk.service.jobs.SqlTaskQuery;
import com.databricks.sdk.service.jobs.Task;
import com.databricks.sdk.service.jobs.TaskDependency;
import com.databricks.sdk.service.sql.Query;
import com.databricks.sdk.service.workspace.ExportFormat;
import com.databricks.sdk.service.workspace.ExportRequest;
import com.databricks.sdk.service.workspace.ExportResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbrConverter {
    private static final Logger log = LoggerFactory.getLogger(DbrConverter.class);
    private WorkspaceClient w;

    public DbrConverter(WorkspaceClient w) {
        this.w = w;
    }

    public Workflow convert(BaseJob baseJob) {
        Workflow workflow = new Workflow();
        Long jobId = baseJob.getJobId();
        if (Objects.isNull(jobId)) {
            workflow.setWorkflowId(baseJob.getSettings().getName());
        } else {
            workflow.setWorkflowId(jobId.toString());
        }
        JobSettings settings = baseJob.getSettings();
        String name = settings.getName();
        workflow.setWorkflowName(name);
        Collection tasks = settings.getTasks();
        ArrayList<RelationPackage> taskNodeRelations = new ArrayList<RelationPackage>();
        ArrayList<WorkflowNode> nodes = new ArrayList<WorkflowNode>();
        for (Task task : tasks) {
            Collection dependsOn;
            SqlTask sqlTask;
            SparkSubmitTask sparkSubmitTask;
            SparkPythonTask sparkPythonTask;
            SparkJarTask sparkJarTask;
            RunJobTask runJobTask;
            PythonWheelTask pythonWheelTask;
            PowerBiTask powerBiTask;
            PipelineTask pipelineTask;
            NotebookTask notebookTask;
            GenAiComputeTask genAiComputeTask;
            ForEachTask forEachTask;
            CleanRoomsNotebookTask cleanRoomsNotebookTask;
            DbtTask dbtTask;
            DashboardTask dashboardTask;
            String taskKey = task.getTaskKey();
            WorkflowNode workflowNode = new WorkflowNode();
            workflowNode.setNodeId(this.generateNodeId(name, taskKey));
            workflowNode.setNodeName(taskKey);
            nodes.add(workflowNode);
            ConditionTask conditionTask = task.getConditionTask();
            if (Objects.nonNull(conditionTask)) {
                workflowNode.setNodeType("condition_task");
                workflowNode.setScript(BwmJsonUtil.toJsonString((Object)conditionTask));
            }
            if (Objects.nonNull(dashboardTask = task.getDashboardTask())) {
                workflowNode.setNodeType("dashboard_task");
                workflowNode.setScript(BwmJsonUtil.toJsonString((Object)dashboardTask));
            }
            if (Objects.nonNull(dbtTask = task.getDbtTask())) {
                workflowNode.setNodeType("dbt_task");
                workflowNode.setScript(BwmJsonUtil.toJsonString((Object)dbtTask));
            }
            if (Objects.nonNull(cleanRoomsNotebookTask = task.getCleanRoomsNotebookTask())) {
                workflowNode.setNodeType("clean_rooms_notebook_task");
                workflowNode.setScript(BwmJsonUtil.toJsonString((Object)cleanRoomsNotebookTask));
            }
            if (Objects.nonNull(forEachTask = task.getForEachTask())) {
                workflowNode.setNodeType("for_each_task");
                workflowNode.setScript(BwmJsonUtil.toJsonString((Object)forEachTask));
            }
            if (Objects.nonNull(genAiComputeTask = task.getGenAiComputeTask())) {
                workflowNode.setNodeType("gen_ai_compute_task");
                workflowNode.setScript(BwmJsonUtil.toJsonString((Object)genAiComputeTask));
            }
            if (Objects.nonNull(notebookTask = task.getNotebookTask())) {
                workflowNode.setNodeType("notebook_task");
                String notebookPath = notebookTask.getNotebookPath();
                Source source = notebookTask.getSource();
                if (Source.WORKSPACE == source) {
                    ExportRequest exportRequest = new ExportRequest();
                    exportRequest.setFormat(ExportFormat.JUPYTER);
                    exportRequest.setPath(notebookPath);
                    ExportResponse export = this.w.workspace().export(exportRequest);
                    workflowNode.setScript(Base64Tool.decode((String)export.getContent()));
                } else {
                    workflowNode.setScript(BwmJsonUtil.toJsonString((Object)notebookTask));
                }
                Map baseParameters = notebookTask.getBaseParameters();
                HashMap paramMap = new HashMap();
                if (baseParameters != null) {
                    paramMap.putAll(baseParameters);
                }
                workflowNode.setParamMap(paramMap);
            }
            if (Objects.nonNull(pipelineTask = task.getPipelineTask())) {
                workflowNode.setNodeType("pipeline_task");
                workflowNode.setScript(BwmJsonUtil.toJsonString((Object)pipelineTask));
            }
            if (Objects.nonNull(powerBiTask = task.getPowerBiTask())) {
                workflowNode.setNodeType("power_bi_task");
                workflowNode.setScript(BwmJsonUtil.toJsonString((Object)pipelineTask));
            }
            if (Objects.nonNull(pythonWheelTask = task.getPythonWheelTask())) {
                workflowNode.setNodeType("power_bi_task");
                workflowNode.setScript(BwmJsonUtil.toJsonString((Object)pythonWheelTask));
            }
            if (Objects.nonNull(runJobTask = task.getRunJobTask())) {
                workflowNode.setNodeType("run_job_task");
                workflowNode.setScript(BwmJsonUtil.toJsonString((Object)runJobTask));
            }
            if (Objects.nonNull(sparkJarTask = task.getSparkJarTask())) {
                workflowNode.setNodeType("spark_jar_task");
                workflowNode.setScript(BwmJsonUtil.toJsonString((Object)sparkJarTask));
            }
            if (Objects.nonNull(sparkPythonTask = task.getSparkPythonTask())) {
                workflowNode.setNodeType("spark_python_task");
                workflowNode.setScript(BwmJsonUtil.toJsonString((Object)sparkPythonTask));
                Source source = sparkPythonTask.getSource();
                if (Source.WORKSPACE == source) {
                    ExportResponse export = this.w.workspace().export(sparkPythonTask.getPythonFile());
                    workflowNode.setScript(Base64Tool.decode((String)export.getContent()));
                }
                Collection parameters = sparkPythonTask.getParameters();
                HashMap<String, Collection> paramMap = new HashMap<String, Collection>();
                paramMap.put("spark_param", parameters);
                paramMap.put("file_path", parameters);
                workflowNode.setCustomProperties(paramMap);
            }
            if (Objects.nonNull(sparkSubmitTask = task.getSparkSubmitTask())) {
                workflowNode.setNodeType("spark_submit_task");
                workflowNode.setScript(BwmJsonUtil.toJsonString((Object)sparkSubmitTask));
            }
            if (Objects.nonNull(sqlTask = task.getSqlTask())) {
                workflowNode.setNodeType("sql_task");
                SqlTaskQuery query = sqlTask.getQuery();
                if (Objects.nonNull(query)) {
                    Query querySingle = this.w.queries().get(query.getQueryId());
                    workflowNode.setScript(querySingle.getQueryText());
                } else {
                    log.warn("not found query ,use file {}", (Object)BwmJsonUtil.toJsonString((Object)sqlTask));
                    SqlTaskFile file = sqlTask.getFile();
                    if (Objects.nonNull(file)) {
                        ExportResponse export = this.w.workspace().export(file.getPath());
                        workflowNode.setScript(Base64Tool.decode((String)export.getContent()));
                    }
                    workflowNode.setScript(BwmJsonUtil.toJsonString((Object)sqlTask));
                }
                Map parameters = sqlTask.getParameters();
                HashMap paramMap = new HashMap();
                if (parameters != null) {
                    paramMap.putAll(parameters);
                }
                workflowNode.setParamMap(paramMap);
            }
            if (CollectionUtils.isEmpty((Collection)(dependsOn = task.getDependsOn()))) continue;
            for (TaskDependency taskDependency : dependsOn) {
                HashMap<String, String> customProperties = workflowNode.getCustomProperties();
                if (customProperties == null) {
                    customProperties = new HashMap<String, String>();
                }
                String outcome = taskDependency.getOutcome();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{outcome})) {
                    customProperties.put("dbr_task_outcome", outcome);
                }
                RelationPackage taskNodeRelation = new RelationPackage();
                taskNodeRelation.setFrom(this.generateNodeId(name, taskDependency.getTaskKey()));
                taskNodeRelation.setTo(this.generateNodeId(name, taskKey));
                taskNodeRelation.setReType(RelationPackage.ReType.NODE);
                taskNodeRelations.add(taskNodeRelation);
            }
        }
        workflow.setWorkflowNodes(nodes);
        workflow.setNodeRelations(taskNodeRelations);
        CronSchedule schedule = settings.getSchedule();
        if (schedule != null) {
            PauseStatus pauseStatus = schedule.getPauseStatus();
            WorkflowTrigger workflowTrigger = new WorkflowTrigger();
            workflowTrigger.setName(schedule.getQuartzCronExpression());
            workflowTrigger.setCron(schedule.getQuartzCronExpression());
            workflowTrigger.setType(pauseStatus.name());
            workflow.setTriggers(List.of(workflowTrigger));
        }
        return workflow;
    }

    private String generateNodeId(String workFlowName, String nodeName) {
        return workFlowName + "_" + nodeName;
    }
}

